package com.finconsgroup.itserr.marketplace.usercommunication.dm.service;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;

import java.util.UUID;

/**
 * Service contract for managing group conversations.
 * Each method is documented to improve generated JavaDoc and maintainability.
 */
public interface GroupConversationService {
    /**
     * Create a new group conversation.
     * @param name group name
     * @param description group description (optional)
     * @param createdBy creator user ID
     * @return the created Conversation entity
     */
    Conversation createGroupConversation(String name, String description, UUID createdBy);

    /**
     * Invite a user to a group conversation.
     * @param conversationId the conversation ID
     * @param userId user to be invited
     * @param invitedBy inviter user ID
     */
    void inviteUserToGroup(UUID conversationId, UUID userId, UUID invitedBy);

    /**
     * Remove a user from a group conversation.
     * @param conversationId the conversation ID
     * @param userId user to remove
     * @param removedBy actor performing the removal
     * @return true if removal succeeded
     */
    boolean removeUserFromGroup(UUID conversationId, UUID userId, UUID removedBy);

    /**
     * Promote a user to admin in a group conversation.
     * @param conversationId the conversation ID
     * @param userId user to promote
     * @param promotedBy actor performing the promotion
     */
    void promoteUserToAdmin(UUID conversationId, UUID userId, UUID promotedBy);

    /**
     * Check if a user is a participant in the conversation.
     * @param conversationId the conversation ID
     * @param userId the user ID
     * @return true if the user is an active participant
     */
    boolean isUserParticipant(UUID conversationId, UUID userId);

    /**
     * Check if a user has admin privileges in the conversation.
     * @param conversationId the conversation ID
     * @param userId the user ID
     * @return true if the user is admin
     */
    boolean hasAdminPrivileges(UUID conversationId, UUID userId);

}