package com.finconsgroup.itserr.marketplace.usercommunication.dm.repository;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@Repository
public interface UserRepository extends JpaRepository<User, UUID> {

    /**
     * Find a user by their unique user ID
     */
    @NonNull
    Optional<User> findById(@NonNull UUID userId);

    /**
     * Find all online users
     */
    List<User> findByOnlineTrue();

    /**
     * Update user online status
     */
    @Modifying
    @Query("UPDATE User u SET u.online = :online, u.lastSeen = :lastSeen WHERE u.id = :userId")
    void updateOnlineStatus(@Param("userId") UUID userId, @Param("online") boolean online, @Param("lastSeen") Instant lastSeen);

    /**
     * Find recently active users (online or last seen within specified time)
     */
    @Query("SELECT u FROM User u WHERE u.online = true OR u.lastSeen >= :since ORDER BY u.lastSeen DESC")
    List<User> findRecentlyActiveUsers(@Param("since") Instant since);
}