package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.UUID;

/**
 * Entity to track individual read receipts for messages in group conversations.
 * This allows tracking which specific users have read which messages.
 */
@Entity
@Table(name = "message_read_receipts",
        uniqueConstraints = @UniqueConstraint(columnNames = {"message_id", "user_id"}))
@SuperBuilder
@Getter
@Setter
@EqualsAndHashCode(of = {"message", "userId"}, callSuper = true)
@NoArgsConstructor
public class MessageReadReceipt extends AbstractUUIDEntity {

    @NotNull(message = "Message ID cannot be blank")
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "message_id", nullable = false, insertable = false, updatable = false)
    private ChatMessage message;

    /**
     * The ID of the related event.
     */
    @Column(name = "message_id", updatable = false)
    private UUID messageId;

    @Column(name = "user_id", nullable = false)
    @NotNull(message = "User ID cannot be blank")
    private UUID userId;

    @Column(name = "conversation_id", nullable = false)
    @NotNull(message = "Conversation ID cannot be blank")
    private UUID conversationId;

    @Column(name = "read_at", nullable = false)
    @NotNull(message = "Read timestamp cannot be null")
    private Instant readAt;

    @Column(name = "created_at", nullable = false)
    private Instant createdAt;

    @Override
    public void prePersist() {
        super.prePersist();
        this.createdAt = Instant.now();
        this.readAt = Instant.now();
    }
}