package com.finconsgroup.itserr.marketplace.usercommunication.dm.configuration.properties;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Map;

/**
 * Represents the configuration properties for a messaging client connection.
 */
@ConfigurationProperties(prefix = "user-communication.dm.messaging.rabbit")
@Getter
@AllArgsConstructor
public class RabbitMQMessagingClientProperties {

    /**
     * Enable/disable address resolution. Defaults to false if not specified.
     */
    private boolean enableAddressResolution;

    /**
     * The username for authentication with the messaging server.
     * Can be null if authentication is not required.
     */
    private String username;

    /**
     * The password for authentication with the messaging server.
     * Can be null if authentication is not required.
     */
    private String password;

    /**
     * The OAuth2 token endpoint URL for Keycloak authentication.
     * Required for OAuth2 authentication flows.
     */
    private String keycloakTokenUrl;

    /**
     * The OAuth2 grant type to use for authentication.
     * Defaults to "client_credentials".
     */
    private String grantType;

    /**
     * Additional OAuth2 parameters for authentication.
     * May include scope, audience, or other custom parameters.
     */
    private Map<String, String> oauthParameters;

    /**
     * The configuration properties for chat exchange and queues.
     */
    private ChatProperties chat;

    /**
     * Represents the configuration properties for a chat messages.
     */
    @Getter
    @AllArgsConstructor
    public static class ChatProperties {

        /**
         * The name of the Rabbit MQ exchange for all chat messages
         */
        private String exchange;

        /**
         * The name of the Rabbit MQ queue for all the chat messages.
         */
        private String chatQueue;

        /**
         * The routing key to route the chat messages to the chat queue.
         */
        private String chatRoutingKey;

        /**
         * The name of the Rabbit MQ queue for all the user notification messages.
         */
        private String userNotificationQueue;

        /**
         * The routing key to route the user notification messages to the user notification queue.
         */
        private String userNotificationRoutingKey;
    }

}