package com.finconsgroup.itserr.marketplace.usercommunication.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.utils.OpenApiUtils;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputCreateDirectConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.UUID;

/**
 * API contract for direct conversation related endpoints.
 * Contains endpoint mappings and parameter annotations.
 */
@Tag(name = "Direct Conversation", description = "Operations related to direct conversations")
@SecurityRequirement(name = "BearerAuth")
@ApiResponses(value = {
        @ApiResponse(responseCode = "500", ref = OpenApiUtils.RESPONSE_INTERNAL_SERVER_ERROR)
})
public interface DirectConversationApi {

    @Operation(summary = "Create or get direct conversation", description = "Create or retrieve a direct conversation between two users.")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Direct conversation returned"),
            @ApiResponse(responseCode = "400", description = "Invalid request")
    })
    @PostMapping(value = "/user-communication/conversations/direct", consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<OutputConversationDto> createDirectConversation(@Valid @RequestBody InputCreateDirectConversationDto request);

    @Operation(summary = "Get direct conversation", description = "Get direct conversation between logged in user and receiver.")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Conversations retrieved")
    })
    @GetMapping(value ="/user-communication/conversations/direct/user", produces = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<OutputConversationDto> getDirectConversationForUserAndReceiver(@NotNull @RequestParam(name = "receiverId") UUID receiverId);

}
