/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.config;

import com.finconsgroup.itserr.marketplace.core.web.bean.FilterProperties;
import com.finconsgroup.itserr.marketplace.search.dm.bean.QuerySearchFields;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import jakarta.annotation.PostConstruct;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public record SearchProperties(String indexName, List<String> defaultSortFields, String defaultSortFieldSeparator, Map<String, String> sortFilterPropertyMap, boolean includeScore, List<QuerySearchFields> termSearchFields, Set<String> nestedPaths, boolean useWildcard, boolean enableDeleteAll, AutoCompletionProperties autoCompletion, GlobalSearchProperties globalSearch, FilterProperties filter, LocalProperties local, FavouriteProperties favourite, List<SyncProperties> syncList) {
    private final String indexName;
    private final List<String> defaultSortFields;
    private final String defaultSortFieldSeparator;
    private final Map<String, String> sortFilterPropertyMap;
    private final boolean includeScore;
    private final List<QuerySearchFields> termSearchFields;
    private final Set<String> nestedPaths;
    private final boolean useWildcard;
    private final boolean enableDeleteAll;
    private final AutoCompletionProperties autoCompletion;
    private final GlobalSearchProperties globalSearch;
    private final FilterProperties filter;
    private final LocalProperties local;
    private final FavouriteProperties favourite;
    private final List<SyncProperties> syncList;
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchProperties.class);
    private static final Map<SearchProperties, Map<String, String>> propertyTypeMapCache = new WeakHashMap();

    public SearchProperties(String indexName, List<String> defaultSortFields, String defaultSortFieldSeparator, Map<String, String> sortFilterPropertyMap, boolean includeScore, List<QuerySearchFields> termSearchFields, Set<String> nestedPaths, boolean useWildcard, boolean enableDeleteAll, AutoCompletionProperties autoCompletion, GlobalSearchProperties globalSearch, FilterProperties filter, LocalProperties local, FavouriteProperties favourite, List<SyncProperties> syncList) {
        this.indexName = indexName;
        this.defaultSortFields = defaultSortFields;
        this.defaultSortFieldSeparator = defaultSortFieldSeparator;
        this.sortFilterPropertyMap = sortFilterPropertyMap;
        this.includeScore = includeScore;
        this.termSearchFields = termSearchFields;
        this.nestedPaths = nestedPaths;
        this.useWildcard = useWildcard;
        this.enableDeleteAll = enableDeleteAll;
        this.autoCompletion = autoCompletion;
        this.globalSearch = globalSearch;
        this.filter = filter;
        this.local = local;
        this.favourite = favourite;
        this.syncList = syncList;
    }

    @PostConstruct
    public void init() {
        this.defaultPropertyTypeMap();
    }

    @NonNull
    public Map<String, String> defaultPropertyTypeMap() {
        return propertyTypeMapCache.computeIfAbsent(this, sp -> {
            log.info("Calculating default property type map for search properties for index - {}", (Object)this.indexName);
            LinkedHashMap propertyMap = new LinkedHashMap();
            Optional.ofNullable(this.termSearchFields).orElse(List.of()).forEach(qsf -> qsf.fieldNames().forEach(fn -> propertyMap.put(fn, qsf.fieldType())));
            return propertyMap;
        });
    }

    @Generated
    public static SearchPropertiesBuilder builder() {
        return new SearchPropertiesBuilder();
    }

    public String indexName() {
        return this.indexName;
    }

    public List<String> defaultSortFields() {
        return this.defaultSortFields;
    }

    public String defaultSortFieldSeparator() {
        return this.defaultSortFieldSeparator;
    }

    public Map<String, String> sortFilterPropertyMap() {
        return this.sortFilterPropertyMap;
    }

    public boolean includeScore() {
        return this.includeScore;
    }

    public List<QuerySearchFields> termSearchFields() {
        return this.termSearchFields;
    }

    public Set<String> nestedPaths() {
        return this.nestedPaths;
    }

    public boolean useWildcard() {
        return this.useWildcard;
    }

    public boolean enableDeleteAll() {
        return this.enableDeleteAll;
    }

    public AutoCompletionProperties autoCompletion() {
        return this.autoCompletion;
    }

    public GlobalSearchProperties globalSearch() {
        return this.globalSearch;
    }

    public FilterProperties filter() {
        return this.filter;
    }

    public LocalProperties local() {
        return this.local;
    }

    public FavouriteProperties favourite() {
        return this.favourite;
    }

    public List<SyncProperties> syncList() {
        return this.syncList;
    }
}

