package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.ImageMinimalDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPageMinimalDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.LocationDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputNewsLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.RegisteredAuthorDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.ImageMinimal;
import com.finconsgroup.itserr.marketplace.search.dm.entity.InstitutionalPageMinimal;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Location;
import com.finconsgroup.itserr.marketplace.search.dm.entity.News;
import com.finconsgroup.itserr.marketplace.search.dm.entity.RegisteredAuthor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-11T20:38:16+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class NewsMapperImpl implements NewsMapper {

    @Override
    public News toEntity(InputNewsDto dto) {
        if ( dto == null ) {
            return null;
        }

        News.NewsBuilder news = News.builder();

        news.id( dto.getId() );
        news.title( dto.getTitle() );
        news.creator( registeredAuthorDtoToRegisteredAuthor( dto.getCreator() ) );
        news.newsType( dto.getNewsType() );
        news.content( dto.getContent() );
        List<String> list = dto.getTags();
        if ( list != null ) {
            news.tags( new ArrayList<String>( list ) );
        }
        news.institutionalPages( institutionalPageMinimalDtoListToInstitutionalPageMinimalList( dto.getInstitutionalPages() ) );
        news.image( imageMinimalDtoToImageMinimal( dto.getImage() ) );
        news.authors( registeredAuthorDtoListToRegisteredAuthorList( dto.getAuthors() ) );
        news.creationTime( dto.getCreationTime() );
        news.updateTime( dto.getUpdateTime() );

        return news.build();
    }

    @Override
    public OutputNewsDto toDto(News entity) {
        if ( entity == null ) {
            return null;
        }

        OutputNewsDto.OutputNewsDtoBuilder outputNewsDto = OutputNewsDto.builder();

        outputNewsDto.id( entity.getId() );
        outputNewsDto.title( entity.getTitle() );
        outputNewsDto.creator( registeredAuthorToRegisteredAuthorDto( entity.getCreator() ) );
        outputNewsDto.newsType( entity.getNewsType() );
        outputNewsDto.content( entity.getContent() );
        List<String> list = entity.getTags();
        if ( list != null ) {
            outputNewsDto.tags( new ArrayList<String>( list ) );
        }
        outputNewsDto.institutionalPages( institutionalPageMinimalListToInstitutionalPageMinimalDtoList( entity.getInstitutionalPages() ) );
        outputNewsDto.image( imageMinimalToImageMinimalDto( entity.getImage() ) );
        outputNewsDto.authors( registeredAuthorListToRegisteredAuthorDtoList( entity.getAuthors() ) );
        outputNewsDto.creationTime( entity.getCreationTime() );
        outputNewsDto.updateTime( entity.getUpdateTime() );

        return outputNewsDto.build();
    }

    @Override
    public OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(News entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchAutoCompleteDataDto.OutputGlobalSearchAutoCompleteDataDtoBuilder outputGlobalSearchAutoCompleteDataDto = OutputGlobalSearchAutoCompleteDataDto.builder();

        outputGlobalSearchAutoCompleteDataDto.id( entity.getId() );
        outputGlobalSearchAutoCompleteDataDto.title( entity.getTitle() );
        outputGlobalSearchAutoCompleteDataDto.score( entity.getScore() );

        return outputGlobalSearchAutoCompleteDataDto.build();
    }

    @Override
    public OutputNewsLocalSearchDto toLocalSearchDto(News entity) {
        if ( entity == null ) {
            return null;
        }

        OutputNewsLocalSearchDto.OutputNewsLocalSearchDtoBuilder outputNewsLocalSearchDto = OutputNewsLocalSearchDto.builder();

        outputNewsLocalSearchDto.id( entity.getId() );
        outputNewsLocalSearchDto.title( entity.getTitle() );
        outputNewsLocalSearchDto.creator( registeredAuthorToRegisteredAuthorDto( entity.getCreator() ) );
        outputNewsLocalSearchDto.newsType( entity.getNewsType() );
        outputNewsLocalSearchDto.content( entity.getContent() );
        List<String> list = entity.getTags();
        if ( list != null ) {
            outputNewsLocalSearchDto.tags( new ArrayList<String>( list ) );
        }
        outputNewsLocalSearchDto.institutionalPages( institutionalPageMinimalListToInstitutionalPageMinimalDtoList( entity.getInstitutionalPages() ) );
        outputNewsLocalSearchDto.image( imageMinimalToImageMinimalDto( entity.getImage() ) );
        outputNewsLocalSearchDto.creationTime( entity.getCreationTime() );
        outputNewsLocalSearchDto.updateTime( entity.getUpdateTime() );

        return outputNewsLocalSearchDto.build();
    }

    @Override
    public OutputGlobalSearchDataDto toGlobalSearchDataDto(News entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchDataDto.OutputGlobalSearchDataDtoBuilder outputGlobalSearchDataDto = OutputGlobalSearchDataDto.builder();

        outputGlobalSearchDataDto.description( entity.getContent() );
        outputGlobalSearchDataDto.imageUrl( entityImageUrl( entity ) );
        outputGlobalSearchDataDto.id( entity.getId() );
        outputGlobalSearchDataDto.title( entity.getTitle() );
        outputGlobalSearchDataDto.score( entity.getScore() );

        return outputGlobalSearchDataDto.build();
    }

    protected Location locationDtoToLocation(LocationDto locationDto) {
        if ( locationDto == null ) {
            return null;
        }

        Location.LocationBuilder location = Location.builder();

        location.zipCode( locationDto.getZipCode() );
        location.city( locationDto.getCity() );
        location.region( locationDto.getRegion() );
        location.country( locationDto.getCountry() );

        return location.build();
    }

    protected RegisteredAuthor registeredAuthorDtoToRegisteredAuthor(RegisteredAuthorDto registeredAuthorDto) {
        if ( registeredAuthorDto == null ) {
            return null;
        }

        RegisteredAuthor.RegisteredAuthorBuilder registeredAuthor = RegisteredAuthor.builder();

        registeredAuthor.id( registeredAuthorDto.getId() );
        registeredAuthor.firstName( registeredAuthorDto.getFirstName() );
        registeredAuthor.lastName( registeredAuthorDto.getLastName() );
        registeredAuthor.email( registeredAuthorDto.getEmail() );
        registeredAuthor.orcid( registeredAuthorDto.getOrcid() );
        registeredAuthor.location( locationDtoToLocation( registeredAuthorDto.getLocation() ) );

        return registeredAuthor.build();
    }

    protected InstitutionalPageMinimal institutionalPageMinimalDtoToInstitutionalPageMinimal(InstitutionalPageMinimalDto institutionalPageMinimalDto) {
        if ( institutionalPageMinimalDto == null ) {
            return null;
        }

        InstitutionalPageMinimal.InstitutionalPageMinimalBuilder institutionalPageMinimal = InstitutionalPageMinimal.builder();

        institutionalPageMinimal.id( institutionalPageMinimalDto.getId() );
        institutionalPageMinimal.name( institutionalPageMinimalDto.getName() );

        return institutionalPageMinimal.build();
    }

    protected List<InstitutionalPageMinimal> institutionalPageMinimalDtoListToInstitutionalPageMinimalList(List<InstitutionalPageMinimalDto> list) {
        if ( list == null ) {
            return null;
        }

        List<InstitutionalPageMinimal> list1 = new ArrayList<InstitutionalPageMinimal>( list.size() );
        for ( InstitutionalPageMinimalDto institutionalPageMinimalDto : list ) {
            list1.add( institutionalPageMinimalDtoToInstitutionalPageMinimal( institutionalPageMinimalDto ) );
        }

        return list1;
    }

    protected ImageMinimal imageMinimalDtoToImageMinimal(ImageMinimalDto imageMinimalDto) {
        if ( imageMinimalDto == null ) {
            return null;
        }

        ImageMinimal.ImageMinimalBuilder imageMinimal = ImageMinimal.builder();

        imageMinimal.id( imageMinimalDto.getId() );
        imageMinimal.url( imageMinimalDto.getUrl() );

        return imageMinimal.build();
    }

    protected List<RegisteredAuthor> registeredAuthorDtoListToRegisteredAuthorList(List<RegisteredAuthorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<RegisteredAuthor> list1 = new ArrayList<RegisteredAuthor>( list.size() );
        for ( RegisteredAuthorDto registeredAuthorDto : list ) {
            list1.add( registeredAuthorDtoToRegisteredAuthor( registeredAuthorDto ) );
        }

        return list1;
    }

    protected LocationDto locationToLocationDto(Location location) {
        if ( location == null ) {
            return null;
        }

        LocationDto.LocationDtoBuilder locationDto = LocationDto.builder();

        locationDto.zipCode( location.getZipCode() );
        locationDto.city( location.getCity() );
        locationDto.region( location.getRegion() );
        locationDto.country( location.getCountry() );

        return locationDto.build();
    }

    protected RegisteredAuthorDto registeredAuthorToRegisteredAuthorDto(RegisteredAuthor registeredAuthor) {
        if ( registeredAuthor == null ) {
            return null;
        }

        RegisteredAuthorDto.RegisteredAuthorDtoBuilder registeredAuthorDto = RegisteredAuthorDto.builder();

        registeredAuthorDto.id( registeredAuthor.getId() );
        registeredAuthorDto.firstName( registeredAuthor.getFirstName() );
        registeredAuthorDto.lastName( registeredAuthor.getLastName() );
        registeredAuthorDto.email( registeredAuthor.getEmail() );
        registeredAuthorDto.orcid( registeredAuthor.getOrcid() );
        registeredAuthorDto.location( locationToLocationDto( registeredAuthor.getLocation() ) );

        return registeredAuthorDto.build();
    }

    protected InstitutionalPageMinimalDto institutionalPageMinimalToInstitutionalPageMinimalDto(InstitutionalPageMinimal institutionalPageMinimal) {
        if ( institutionalPageMinimal == null ) {
            return null;
        }

        InstitutionalPageMinimalDto.InstitutionalPageMinimalDtoBuilder institutionalPageMinimalDto = InstitutionalPageMinimalDto.builder();

        institutionalPageMinimalDto.id( institutionalPageMinimal.getId() );
        institutionalPageMinimalDto.name( institutionalPageMinimal.getName() );

        return institutionalPageMinimalDto.build();
    }

    protected List<InstitutionalPageMinimalDto> institutionalPageMinimalListToInstitutionalPageMinimalDtoList(List<InstitutionalPageMinimal> list) {
        if ( list == null ) {
            return null;
        }

        List<InstitutionalPageMinimalDto> list1 = new ArrayList<InstitutionalPageMinimalDto>( list.size() );
        for ( InstitutionalPageMinimal institutionalPageMinimal : list ) {
            list1.add( institutionalPageMinimalToInstitutionalPageMinimalDto( institutionalPageMinimal ) );
        }

        return list1;
    }

    protected ImageMinimalDto imageMinimalToImageMinimalDto(ImageMinimal imageMinimal) {
        if ( imageMinimal == null ) {
            return null;
        }

        ImageMinimalDto.ImageMinimalDtoBuilder<?, ?> imageMinimalDto = ImageMinimalDto.builder();

        imageMinimalDto.id( imageMinimal.getId() );
        imageMinimalDto.url( imageMinimal.getUrl() );

        return imageMinimalDto.build();
    }

    protected List<RegisteredAuthorDto> registeredAuthorListToRegisteredAuthorDtoList(List<RegisteredAuthor> list) {
        if ( list == null ) {
            return null;
        }

        List<RegisteredAuthorDto> list1 = new ArrayList<RegisteredAuthorDto>( list.size() );
        for ( RegisteredAuthor registeredAuthor : list ) {
            list1.add( registeredAuthorToRegisteredAuthorDto( registeredAuthor ) );
        }

        return list1;
    }

    private String entityImageUrl(News news) {
        ImageMinimal image = news.getImage();
        if ( image == null ) {
            return null;
        }
        return image.getUrl();
    }
}
