/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service;

import com.finconsgroup.itserr.marketplace.core.web.bean.FilterProperties;
import com.finconsgroup.itserr.marketplace.core.web.bean.QueryFilter;
import com.finconsgroup.itserr.marketplace.core.web.enums.FilterOperator;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.core.web.utils.FilterUtils;
import com.finconsgroup.itserr.marketplace.search.dm.bean.ContainsAnyTermsRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.ContainsAnyTermsWithFiltersRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.PostProcessFilterResult;
import com.finconsgroup.itserr.marketplace.search.dm.bean.QueryRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.QuerySearchFields;
import com.finconsgroup.itserr.marketplace.search.dm.bean.SearchRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.TopHitsAggregationRequest;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import com.finconsgroup.itserr.marketplace.search.dm.util.SortUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;

public interface SearchService<T, L> {
    public static final String SORT_FIELD_FORMAT = "%s:%s";
    public static final String TEXT_INNER_KEYWORD_FIELD_FORMAT = "%s.keyword";
    public static final String FILTER_KEY_MINE_ONLY = "mineOnly";

    @NonNull
    default public <R> Page<R> search(@NonNull SearchRequest searchRequest, List<String> sourceFields, Function<T, R> mapper, @NonNull Pageable pageable) {
        QueryRequest queryRequest = this.buildQueryRequest(searchRequest, sourceFields);
        return this.getCustomQueryRepository().findPageForQuery(queryRequest, pageable).map(mapper);
    }

    @NonNull
    default public <R> Map<String, List<R>> searchByAggregation(@NonNull SearchRequest searchRequest, @NonNull List<String> sourceFields, int topHitsLimit, @NonNull SearchProperties.AggregationProperties aggregation, @NonNull Function<T, R> mapper) {
        SearchProperties searchProperties = this.getSearchProperties();
        QueryRequest queryRequest = this.buildQueryRequest(searchRequest, sourceFields);
        TopHitsAggregationRequest topHitsAggregationRequest = TopHitsAggregationRequest.builder().name(aggregation.name()).term(aggregation.term()).topHitsLimit(topHitsLimit).sourceFields(sourceFields).includeScore(searchProperties.includeScore()).documentClass(this.getDocumentClass()).build();
        Map topHitsByAggregationTerm = this.getCustomAggregationRepository().findTopHitsForQueryByTerm(queryRequest, topHitsAggregationRequest);
        LinkedHashMap topHitResultsByAggregationTerm = new LinkedHashMap();
        topHitsByAggregationTerm.forEach((aggregationTerm, topHits) -> topHitResultsByAggregationTerm.put((String)aggregationTerm, topHits.stream().map(mapper).collect(Collectors.toList())));
        return topHitResultsByAggregationTerm;
    }

    default public QueryRequest<T> buildQueryRequest(SearchRequest searchRequest, List<String> sourceFields) {
        SearchProperties searchProperties = this.getSearchProperties();
        ContainsAnyTermsRequest termsQueryRequest = null;
        if (searchRequest.terms() != null && !searchRequest.terms().isEmpty()) {
            termsQueryRequest = ContainsAnyTermsRequest.builder().documentClass(this.getDocumentClass()).terms(searchRequest.terms()).sourceFields(sourceFields).nestedPaths(searchProperties.nestedPaths()).searchFields(Optional.ofNullable(searchRequest.termSearchFields()).orElse(searchProperties.termSearchFields())).useWildcard(searchProperties.useWildcard()).includeScore(searchProperties.includeScore()).build();
        }
        return ContainsAnyTermsWithFiltersRequest.builder().documentClass(this.getDocumentClass()).sourceFields(sourceFields).nestedPaths(searchProperties.nestedPaths()).ids(searchRequest.ids()).containsAnyTermsRequest(termsQueryRequest).queryFilters(searchRequest.queryFilters()).defaultPropertyTypeMap(searchProperties.defaultPropertyTypeMap()).includeScore(searchProperties.includeScore()).build();
    }

    @NonNull
    default public Map<String, String> buildSortFilterPropertyMap(@NonNull SearchProperties searchProperties, @NonNull Map<String, String> defaultSortPropertyMap) {
        HashMap<String, String> sortFilterPropertyMap = new HashMap<String, String>();
        if (searchProperties.sortFilterPropertyMap() != null) {
            sortFilterPropertyMap.putAll(searchProperties.sortFilterPropertyMap());
        }
        searchProperties.termSearchFields().stream().filter(qsf -> "text".equals(qsf.fieldType())).findFirst().map(QuerySearchFields::fieldNames).ifPresent(textFields -> textFields.forEach(field -> sortFilterPropertyMap.put((String)field, TEXT_INNER_KEYWORD_FIELD_FORMAT.formatted(field))));
        sortFilterPropertyMap.putAll(defaultSortPropertyMap);
        return sortFilterPropertyMap;
    }

    @NonNull
    default public Pageable applySort(@NonNull Pageable pageable, @NonNull SearchProperties searchProperties, @NonNull Map<String, String> sortPropertyMap) {
        List sortFields = pageable.getSort().stream().map(order -> SORT_FIELD_FORMAT.formatted(order.getProperty(), order.getDirection())).toList();
        if (sortFields.isEmpty()) {
            sortFields = searchProperties.defaultSortFields();
        }
        Sort sort = SortUtils.buildSort((List)sortFields, (String)searchProperties.defaultSortFieldSeparator(), sortPropertyMap);
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sort);
    }

    @NonNull
    default public List<QueryFilter> buildQueryFilters(String filters, @NonNull Map<String, String> filterPropertyMap) {
        Optional<FilterProperties> optFilterProperties = Optional.ofNullable(this.getSearchProperties().filter());
        List queryFilters = FilterUtils.buildQueryFilters((String)filters, (String)optFilterProperties.map(FilterProperties::separator).orElse(null), (String)optFilterProperties.map(FilterProperties::keyValueSeparator).orElse(null), (String)optFilterProperties.map(FilterProperties::valueSeparator).orElse(null), filterPropertyMap);
        return this.postProcessQueryFilters(queryFilters);
    }

    @NonNull
    default public List<QueryFilter> postProcessQueryFilters(@NonNull List<QueryFilter> queryFilters) {
        ArrayList<QueryFilter> processedFilters = new ArrayList<QueryFilter>(queryFilters.size());
        for (QueryFilter queryFilter : queryFilters) {
            PostProcessFilterResult postProcessFilterResult = this.postProcessQueryFilter(queryFilter);
            if (postProcessFilterResult.processed()) {
                if (postProcessFilterResult.skip()) continue;
                processedFilters.add(Optional.ofNullable(postProcessFilterResult.queryFilter()).orElse(queryFilter));
                continue;
            }
            processedFilters.add(queryFilter);
        }
        return processedFilters;
    }

    @NonNull
    default public PostProcessFilterResult postProcessQueryFilter(@NonNull QueryFilter queryFilter) {
        PostProcessFilterResult.PostProcessFilterResultBuilder resultBuilder = PostProcessFilterResult.builder();
        if (FILTER_KEY_MINE_ONLY.equals(queryFilter.fieldName())) {
            this.postProcessMineOnlyQueryFilter(queryFilter, resultBuilder);
        }
        return resultBuilder.build();
    }

    default public void postProcessMineOnlyQueryFilter(@NonNull QueryFilter queryFilter, @NonNull PostProcessFilterResult.PostProcessFilterResultBuilder resultBuilder) {
        resultBuilder.processed(true);
        if (FilterOperator.EQ == queryFilter.operator() && queryFilter.filterValues().size() == 1 && Boolean.parseBoolean((String)queryFilter.filterValues().getFirst())) {
            Optional userIdOpt = JwtTokenHolder.getUserId();
            Optional creatorUserIdFieldName = this.getCreatorUserIdFieldName();
            if (userIdOpt.isPresent() && creatorUserIdFieldName.isPresent()) {
                QueryFilter processedQueryFilter = QueryFilter.builder().fieldName((String)creatorUserIdFieldName.get()).operator(FilterOperator.EQ).filterValues(List.of(((UUID)userIdOpt.get()).toString())).build();
                resultBuilder.skip(false).queryFilter(processedQueryFilter);
            }
        }
    }

    @NonNull
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String var1);

    @NonNull
    public Page<L> getLocalSearch(String var1, String var2, @NonNull Pageable var3);

    @NonNull
    public List<OutputGlobalSearchDto> getSearch(@NonNull String var1);

    @NonNull
    public Class<T> getDocumentClass();

    @NonNull
    public SearchProperties getSearchProperties();

    @NonNull
    public CustomQueryRepository getCustomQueryRepository();

    @NonNull
    public CustomAggregationRepository getCustomAggregationRepository();

    default public Optional<String> getCreatorUserIdFieldName() {
        return Optional.empty();
    }
}

