/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.core.web.bean.FilterProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.CatalogSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.EventSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.InstitutionalPageSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.NewsSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.UserProfileSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CatalogRepository;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.spring.boot.autoconfigure.RestClientBuilderCustomizer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.data.web.config.EnableSpringDataWebSupport;

@Configuration
@EnableSpringDataWebSupport(pageSerializationMode=EnableSpringDataWebSupport.PageSerializationMode.VIA_DTO)
@EnableElasticsearchRepositories(basePackageClasses={CatalogRepository.class}, repositoryImplementationPostfix="OpenSearchImpl")
public class SearchConfiguration {
    @Bean
    RestClientBuilderCustomizer customizer(@Value(value="${search.rest-client.allow-self-ssl:false}") boolean allowSelfSsl) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public JsonpMapper jacksonJsonpMapper(ObjectMapper objectMapper) {
        return new JacksonJsonpMapper(objectMapper);
    }

    @Bean(value={"filterPropertyMap"})
    public Map<String, FilterProperties> filterPropertyMap(CatalogSearchProperties catalogSearchProperties, UserProfileSearchProperties userProfileSearchProperties, InstitutionalPageSearchProperties institutionalPageSearchProperties, EventSearchProperties eventSearchProperties, NewsSearchProperties newsSearchProperties) {
        HashMap<String, FilterProperties> filterPropertyMap = new HashMap<String, FilterProperties>();
        if (catalogSearchProperties.search().filter() != null) {
            filterPropertyMap.put("catalog", catalogSearchProperties.search().filter());
        }
        if (userProfileSearchProperties.search().filter() != null) {
            filterPropertyMap.put("profile", userProfileSearchProperties.search().filter());
        }
        if (institutionalPageSearchProperties.search().filter() != null) {
            filterPropertyMap.put("institutional_page", institutionalPageSearchProperties.search().filter());
        }
        if (eventSearchProperties.search().filter() != null) {
            filterPropertyMap.put("event", eventSearchProperties.search().filter());
        }
        if (newsSearchProperties.search().filter() != null) {
            filterPropertyMap.put("news", newsSearchProperties.search().filter());
        }
        return Map.copyOf(filterPropertyMap);
    }
}

