package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.AuthorDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.EndorsementDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ExpertiseDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.LocationDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ManualReferenceDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputUserProfileLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.PublicationDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ReferencesDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.UserProfileCvDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.UserProfileMinimalDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.UserProfileProjectDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Author;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Location;
import com.finconsgroup.itserr.marketplace.search.dm.entity.ManualReference;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Publication;
import com.finconsgroup.itserr.marketplace.search.dm.entity.References;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfileCv;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfileMinimal;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfileProject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-10T12:31:45+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class UserProfileMapperImpl implements UserProfileMapper {

    @Override
    public UserProfile toEntity(InputUserProfileDto dto) {
        if ( dto == null ) {
            return null;
        }

        UserProfile.UserProfileBuilder userProfile = UserProfile.builder();

        userProfile.id( dto.getId() );
        userProfile.firstName( dto.getFirstName() );
        userProfile.lastName( dto.getLastName() );
        userProfile.email( dto.getEmail() );
        userProfile.userProfileFolderId( dto.getUserProfileFolderId() );
        userProfile.imageUrl( dto.getImageUrl() );
        userProfile.userExists( dto.getUserExists() );
        userProfile.projects( userProfileProjectDtoListToUserProfileProjectList( dto.getProjects() ) );
        userProfile.cv( userProfileCvDtoToUserProfileCv( dto.getCv() ) );
        userProfile.orcid( dto.getOrcid() );
        userProfile.openToCollaboration( dto.getOpenToCollaboration() );
        userProfile.showPublicEmail( dto.isShowPublicEmail() );
        userProfile.personalWebsite( dto.getPersonalWebsite() );
        userProfile.linkedinProfile( dto.getLinkedinProfile() );
        userProfile.socialProfile( dto.getSocialProfile() );
        userProfile.shortBio( dto.getShortBio() );
        userProfile.workingLocation( locationDtoToLocation( dto.getWorkingLocation() ) );
        userProfile.organizationAffiliation( dto.getOrganizationAffiliation() );
        List<String> list1 = dto.getSsd();
        if ( list1 != null ) {
            userProfile.ssd( new ArrayList<String>( list1 ) );
        }
        userProfile.expertises( expertiseDtoListToExpertiseList( dto.getExpertises() ) );
        userProfile.references( referencesDtoToReferences( dto.getReferences() ) );
        userProfile.language( dto.getLanguage() );
        userProfile.publicProfile( dto.isPublicProfile() );
        List<String> list3 = dto.getInterests();
        if ( list3 != null ) {
            userProfile.interests( new ArrayList<String>( list3 ) );
        }
        userProfile.creationTime( dto.getCreationTime() );
        userProfile.updateTime( dto.getUpdateTime() );

        return userProfile.build();
    }

    @Override
    public OutputUserProfileDto toDto(UserProfile entity) {
        if ( entity == null ) {
            return null;
        }

        OutputUserProfileDto.OutputUserProfileDtoBuilder outputUserProfileDto = OutputUserProfileDto.builder();

        outputUserProfileDto.id( entity.getId() );
        outputUserProfileDto.firstName( entity.getFirstName() );
        outputUserProfileDto.lastName( entity.getLastName() );
        outputUserProfileDto.email( entity.getEmail() );
        outputUserProfileDto.userProfileFolderId( entity.getUserProfileFolderId() );
        outputUserProfileDto.imageUrl( entity.getImageUrl() );
        outputUserProfileDto.userExists( entity.getUserExists() );
        outputUserProfileDto.projects( userProfileProjectListToUserProfileProjectDtoList( entity.getProjects() ) );
        outputUserProfileDto.cv( userProfileCvToUserProfileCvDto( entity.getCv() ) );
        outputUserProfileDto.orcid( entity.getOrcid() );
        outputUserProfileDto.openToCollaboration( entity.getOpenToCollaboration() );
        if ( entity.getShowPublicEmail() != null ) {
            outputUserProfileDto.showPublicEmail( entity.getShowPublicEmail() );
        }
        outputUserProfileDto.personalWebsite( entity.getPersonalWebsite() );
        outputUserProfileDto.linkedinProfile( entity.getLinkedinProfile() );
        outputUserProfileDto.socialProfile( entity.getSocialProfile() );
        outputUserProfileDto.shortBio( entity.getShortBio() );
        outputUserProfileDto.workingLocation( locationToLocationDto( entity.getWorkingLocation() ) );
        outputUserProfileDto.organizationAffiliation( entity.getOrganizationAffiliation() );
        List<String> list1 = entity.getSsd();
        if ( list1 != null ) {
            outputUserProfileDto.ssd( new ArrayList<String>( list1 ) );
        }
        outputUserProfileDto.expertises( expertiseListToExpertiseDtoList( entity.getExpertises() ) );
        outputUserProfileDto.references( referencesToReferencesDto( entity.getReferences() ) );
        outputUserProfileDto.language( entity.getLanguage() );
        outputUserProfileDto.publicProfile( entity.isPublicProfile() );
        List<String> list3 = entity.getInterests();
        if ( list3 != null ) {
            outputUserProfileDto.interests( new ArrayList<String>( list3 ) );
        }
        outputUserProfileDto.creationTime( entity.getCreationTime() );
        outputUserProfileDto.updateTime( entity.getUpdateTime() );

        return outputUserProfileDto.build();
    }

    @Override
    public OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(UserProfile entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchAutoCompleteDataDto.OutputGlobalSearchAutoCompleteDataDtoBuilder outputGlobalSearchAutoCompleteDataDto = OutputGlobalSearchAutoCompleteDataDto.builder();

        outputGlobalSearchAutoCompleteDataDto.title( mapEntityToTitle( entity ) );
        outputGlobalSearchAutoCompleteDataDto.id( entity.getId() );
        outputGlobalSearchAutoCompleteDataDto.score( entity.getScore() );

        return outputGlobalSearchAutoCompleteDataDto.build();
    }

    @Override
    public OutputUserProfileLocalSearchDto toLocalSearchDto(UserProfile entity) {
        if ( entity == null ) {
            return null;
        }

        OutputUserProfileLocalSearchDto.OutputUserProfileLocalSearchDtoBuilder outputUserProfileLocalSearchDto = OutputUserProfileLocalSearchDto.builder();

        outputUserProfileLocalSearchDto.id( entity.getId() );
        outputUserProfileLocalSearchDto.firstName( entity.getFirstName() );
        outputUserProfileLocalSearchDto.lastName( entity.getLastName() );
        outputUserProfileLocalSearchDto.projects( userProfileProjectListToUserProfileProjectDtoList( entity.getProjects() ) );
        outputUserProfileLocalSearchDto.shortBio( entity.getShortBio() );
        outputUserProfileLocalSearchDto.openToCollaboration( entity.getOpenToCollaboration() );
        outputUserProfileLocalSearchDto.organizationAffiliation( entity.getOrganizationAffiliation() );
        List<String> list1 = entity.getSsd();
        if ( list1 != null ) {
            outputUserProfileLocalSearchDto.ssd( new ArrayList<String>( list1 ) );
        }
        outputUserProfileLocalSearchDto.expertises( expertiseListToExpertiseDtoList( entity.getExpertises() ) );
        outputUserProfileLocalSearchDto.imageUrl( entity.getImageUrl() );
        outputUserProfileLocalSearchDto.language( entity.getLanguage() );
        List<String> list3 = entity.getInterests();
        if ( list3 != null ) {
            outputUserProfileLocalSearchDto.interests( new ArrayList<String>( list3 ) );
        }

        return outputUserProfileLocalSearchDto.build();
    }

    @Override
    public OutputGlobalSearchDataDto toGlobalSearchDataDto(UserProfile entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchDataDto.OutputGlobalSearchDataDtoBuilder outputGlobalSearchDataDto = OutputGlobalSearchDataDto.builder();

        outputGlobalSearchDataDto.title( mapEntityToTitle( entity ) );
        outputGlobalSearchDataDto.description( entity.getShortBio() );
        outputGlobalSearchDataDto.id( entity.getId() );
        outputGlobalSearchDataDto.imageUrl( entity.getImageUrl() );
        outputGlobalSearchDataDto.score( entity.getScore() );

        return outputGlobalSearchDataDto.build();
    }

    @Override
    public UserProfileMinimal fullEntityToMinimalEntity(UserProfile entity) {
        if ( entity == null ) {
            return null;
        }

        UserProfileMinimal.UserProfileMinimalBuilder userProfileMinimal = UserProfileMinimal.builder();

        userProfileMinimal.id( entity.getId() );
        userProfileMinimal.firstName( entity.getFirstName() );
        userProfileMinimal.lastName( entity.getLastName() );
        userProfileMinimal.email( entity.getEmail() );
        userProfileMinimal.orcid( entity.getOrcid() );

        return userProfileMinimal.build();
    }

    @Override
    public UserProfileMinimal toMinimalEntity(UserProfileMinimalDto dto) {
        if ( dto == null ) {
            return null;
        }

        UserProfileMinimal.UserProfileMinimalBuilder userProfileMinimal = UserProfileMinimal.builder();

        userProfileMinimal.id( dto.getId() );
        userProfileMinimal.firstName( dto.getFirstName() );
        userProfileMinimal.lastName( dto.getLastName() );
        userProfileMinimal.email( dto.getEmail() );
        userProfileMinimal.orcid( dto.getOrcid() );

        return userProfileMinimal.build();
    }

    @Override
    public UserProfileMinimalDto toMinimalDto(UserProfileMinimal dto) {
        if ( dto == null ) {
            return null;
        }

        UserProfileMinimalDto.UserProfileMinimalDtoBuilder userProfileMinimalDto = UserProfileMinimalDto.builder();

        userProfileMinimalDto.id( dto.getId() );
        userProfileMinimalDto.firstName( dto.getFirstName() );
        userProfileMinimalDto.lastName( dto.getLastName() );
        userProfileMinimalDto.email( dto.getEmail() );
        userProfileMinimalDto.orcid( dto.getOrcid() );

        return userProfileMinimalDto.build();
    }

    protected UserProfileProject userProfileProjectDtoToUserProfileProject(UserProfileProjectDto userProfileProjectDto) {
        if ( userProfileProjectDto == null ) {
            return null;
        }

        UserProfileProject.UserProfileProjectBuilder userProfileProject = UserProfileProject.builder();

        userProfileProject.projectId( userProfileProjectDto.getProjectId() );
        userProfileProject.displayName( userProfileProjectDto.getDisplayName() );
        userProfileProject.wp( userProfileProjectDto.getWp() );
        userProfileProject.rootProjectId( userProfileProjectDto.getRootProjectId() );
        userProfileProject.rootProjectDisplayName( userProfileProjectDto.getRootProjectDisplayName() );

        return userProfileProject.build();
    }

    protected List<UserProfileProject> userProfileProjectDtoListToUserProfileProjectList(List<UserProfileProjectDto> list) {
        if ( list == null ) {
            return null;
        }

        List<UserProfileProject> list1 = new ArrayList<UserProfileProject>( list.size() );
        for ( UserProfileProjectDto userProfileProjectDto : list ) {
            list1.add( userProfileProjectDtoToUserProfileProject( userProfileProjectDto ) );
        }

        return list1;
    }

    protected UserProfileCv userProfileCvDtoToUserProfileCv(UserProfileCvDto userProfileCvDto) {
        if ( userProfileCvDto == null ) {
            return null;
        }

        UserProfileCv.UserProfileCvBuilder userProfileCv = UserProfileCv.builder();

        userProfileCv.fileUrl( userProfileCvDto.getFileUrl() );
        userProfileCv.filename( userProfileCvDto.getFilename() );
        userProfileCv.size( userProfileCvDto.getSize() );

        return userProfileCv.build();
    }

    protected Location locationDtoToLocation(LocationDto locationDto) {
        if ( locationDto == null ) {
            return null;
        }

        Location.LocationBuilder location = Location.builder();

        location.zipCode( locationDto.getZipCode() );
        location.city( locationDto.getCity() );
        location.region( locationDto.getRegion() );
        location.country( locationDto.getCountry() );

        return location.build();
    }

    protected UserProfile.Endorsement endorsementDtoToEndorsement(EndorsementDto endorsementDto) {
        if ( endorsementDto == null ) {
            return null;
        }

        UserProfile.Endorsement.EndorsementBuilder endorsement = UserProfile.Endorsement.builder();

        endorsement.endorserId( endorsementDto.getEndorserId() );
        endorsement.firstName( endorsementDto.getFirstName() );
        endorsement.lastName( endorsementDto.getLastName() );
        endorsement.preferredUsername( endorsementDto.getPreferredUsername() );
        endorsement.email( endorsementDto.getEmail() );
        endorsement.imageUrl( endorsementDto.getImageUrl() );
        endorsement.shortBio( endorsementDto.getShortBio() );

        return endorsement.build();
    }

    protected List<UserProfile.Endorsement> endorsementDtoListToEndorsementList(List<EndorsementDto> list) {
        if ( list == null ) {
            return null;
        }

        List<UserProfile.Endorsement> list1 = new ArrayList<UserProfile.Endorsement>( list.size() );
        for ( EndorsementDto endorsementDto : list ) {
            list1.add( endorsementDtoToEndorsement( endorsementDto ) );
        }

        return list1;
    }

    protected UserProfile.Expertise expertiseDtoToExpertise(ExpertiseDto expertiseDto) {
        if ( expertiseDto == null ) {
            return null;
        }

        UserProfile.Expertise.ExpertiseBuilder expertise = UserProfile.Expertise.builder();

        expertise.id( expertiseDto.getId() );
        expertise.labelId( expertiseDto.getLabelId() );
        expertise.displayName( expertiseDto.getDisplayName() );
        expertise.endorsementCount( expertiseDto.getEndorsementCount() );
        expertise.endorsements( endorsementDtoListToEndorsementList( expertiseDto.getEndorsements() ) );

        return expertise.build();
    }

    protected List<UserProfile.Expertise> expertiseDtoListToExpertiseList(List<ExpertiseDto> list) {
        if ( list == null ) {
            return null;
        }

        List<UserProfile.Expertise> list1 = new ArrayList<UserProfile.Expertise>( list.size() );
        for ( ExpertiseDto expertiseDto : list ) {
            list1.add( expertiseDtoToExpertise( expertiseDto ) );
        }

        return list1;
    }

    protected Author authorDtoToAuthor(AuthorDto authorDto) {
        if ( authorDto == null ) {
            return null;
        }

        Author.AuthorBuilder author = Author.builder();

        author.id( authorDto.getId() );
        author.firstName( authorDto.getFirstName() );
        author.lastName( authorDto.getLastName() );
        author.email( authorDto.getEmail() );
        author.orcid( authorDto.getOrcid() );

        return author.build();
    }

    protected List<Author> authorDtoListToAuthorList(List<AuthorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Author> list1 = new ArrayList<Author>( list.size() );
        for ( AuthorDto authorDto : list ) {
            list1.add( authorDtoToAuthor( authorDto ) );
        }

        return list1;
    }

    protected Publication publicationDtoToPublication(PublicationDto publicationDto) {
        if ( publicationDto == null ) {
            return null;
        }

        Publication.PublicationBuilder publication = Publication.builder();

        publication.date( publicationDto.getDate() );
        publication.location( locationDtoToLocation( publicationDto.getLocation() ) );

        return publication.build();
    }

    protected ManualReference manualReferenceDtoToManualReference(ManualReferenceDto manualReferenceDto) {
        if ( manualReferenceDto == null ) {
            return null;
        }

        ManualReference.ManualReferenceBuilder manualReference = ManualReference.builder();

        manualReference.title( manualReferenceDto.getTitle() );
        manualReference.url( manualReferenceDto.getUrl() );
        manualReference.journalOrConference( manualReferenceDto.getJournalOrConference() );
        manualReference.authors( authorDtoListToAuthorList( manualReferenceDto.getAuthors() ) );
        manualReference.volume( manualReferenceDto.getVolume() );
        manualReference.paragraph( manualReferenceDto.getParagraph() );
        manualReference.pages( manualReferenceDto.getPages() );
        manualReference.publication( publicationDtoToPublication( manualReferenceDto.getPublication() ) );

        return manualReference.build();
    }

    protected List<ManualReference> manualReferenceDtoListToManualReferenceList(List<ManualReferenceDto> list) {
        if ( list == null ) {
            return null;
        }

        List<ManualReference> list1 = new ArrayList<ManualReference>( list.size() );
        for ( ManualReferenceDto manualReferenceDto : list ) {
            list1.add( manualReferenceDtoToManualReference( manualReferenceDto ) );
        }

        return list1;
    }

    protected References referencesDtoToReferences(ReferencesDto referencesDto) {
        if ( referencesDto == null ) {
            return null;
        }

        References.ReferencesBuilder references = References.builder();

        List<String> list = referencesDto.getDois();
        if ( list != null ) {
            references.dois( new ArrayList<String>( list ) );
        }
        references.manualReferences( manualReferenceDtoListToManualReferenceList( referencesDto.getManualReferences() ) );

        return references.build();
    }

    protected UserProfileProjectDto userProfileProjectToUserProfileProjectDto(UserProfileProject userProfileProject) {
        if ( userProfileProject == null ) {
            return null;
        }

        UserProfileProjectDto.UserProfileProjectDtoBuilder userProfileProjectDto = UserProfileProjectDto.builder();

        userProfileProjectDto.projectId( userProfileProject.getProjectId() );
        userProfileProjectDto.displayName( userProfileProject.getDisplayName() );
        userProfileProjectDto.wp( userProfileProject.getWp() );
        userProfileProjectDto.rootProjectId( userProfileProject.getRootProjectId() );
        userProfileProjectDto.rootProjectDisplayName( userProfileProject.getRootProjectDisplayName() );

        return userProfileProjectDto.build();
    }

    protected List<UserProfileProjectDto> userProfileProjectListToUserProfileProjectDtoList(List<UserProfileProject> list) {
        if ( list == null ) {
            return null;
        }

        List<UserProfileProjectDto> list1 = new ArrayList<UserProfileProjectDto>( list.size() );
        for ( UserProfileProject userProfileProject : list ) {
            list1.add( userProfileProjectToUserProfileProjectDto( userProfileProject ) );
        }

        return list1;
    }

    protected UserProfileCvDto userProfileCvToUserProfileCvDto(UserProfileCv userProfileCv) {
        if ( userProfileCv == null ) {
            return null;
        }

        UserProfileCvDto.UserProfileCvDtoBuilder userProfileCvDto = UserProfileCvDto.builder();

        userProfileCvDto.fileUrl( userProfileCv.getFileUrl() );
        userProfileCvDto.filename( userProfileCv.getFilename() );
        userProfileCvDto.size( userProfileCv.getSize() );

        return userProfileCvDto.build();
    }

    protected LocationDto locationToLocationDto(Location location) {
        if ( location == null ) {
            return null;
        }

        LocationDto.LocationDtoBuilder locationDto = LocationDto.builder();

        locationDto.zipCode( location.getZipCode() );
        locationDto.city( location.getCity() );
        locationDto.region( location.getRegion() );
        locationDto.country( location.getCountry() );

        return locationDto.build();
    }

    protected EndorsementDto endorsementToEndorsementDto(UserProfile.Endorsement endorsement) {
        if ( endorsement == null ) {
            return null;
        }

        EndorsementDto.EndorsementDtoBuilder endorsementDto = EndorsementDto.builder();

        endorsementDto.endorserId( endorsement.getEndorserId() );
        endorsementDto.firstName( endorsement.getFirstName() );
        endorsementDto.lastName( endorsement.getLastName() );
        endorsementDto.preferredUsername( endorsement.getPreferredUsername() );
        endorsementDto.email( endorsement.getEmail() );
        endorsementDto.imageUrl( endorsement.getImageUrl() );
        endorsementDto.shortBio( endorsement.getShortBio() );

        return endorsementDto.build();
    }

    protected List<EndorsementDto> endorsementListToEndorsementDtoList(List<UserProfile.Endorsement> list) {
        if ( list == null ) {
            return null;
        }

        List<EndorsementDto> list1 = new ArrayList<EndorsementDto>( list.size() );
        for ( UserProfile.Endorsement endorsement : list ) {
            list1.add( endorsementToEndorsementDto( endorsement ) );
        }

        return list1;
    }

    protected ExpertiseDto expertiseToExpertiseDto(UserProfile.Expertise expertise) {
        if ( expertise == null ) {
            return null;
        }

        ExpertiseDto.ExpertiseDtoBuilder expertiseDto = ExpertiseDto.builder();

        expertiseDto.id( expertise.getId() );
        expertiseDto.labelId( expertise.getLabelId() );
        expertiseDto.displayName( expertise.getDisplayName() );
        expertiseDto.endorsementCount( expertise.getEndorsementCount() );
        expertiseDto.endorsements( endorsementListToEndorsementDtoList( expertise.getEndorsements() ) );

        return expertiseDto.build();
    }

    protected List<ExpertiseDto> expertiseListToExpertiseDtoList(List<UserProfile.Expertise> list) {
        if ( list == null ) {
            return null;
        }

        List<ExpertiseDto> list1 = new ArrayList<ExpertiseDto>( list.size() );
        for ( UserProfile.Expertise expertise : list ) {
            list1.add( expertiseToExpertiseDto( expertise ) );
        }

        return list1;
    }

    protected AuthorDto authorToAuthorDto(Author author) {
        if ( author == null ) {
            return null;
        }

        AuthorDto.AuthorDtoBuilder authorDto = AuthorDto.builder();

        authorDto.id( author.getId() );
        authorDto.firstName( author.getFirstName() );
        authorDto.lastName( author.getLastName() );
        authorDto.email( author.getEmail() );
        authorDto.orcid( author.getOrcid() );

        return authorDto.build();
    }

    protected List<AuthorDto> authorListToAuthorDtoList(List<Author> list) {
        if ( list == null ) {
            return null;
        }

        List<AuthorDto> list1 = new ArrayList<AuthorDto>( list.size() );
        for ( Author author : list ) {
            list1.add( authorToAuthorDto( author ) );
        }

        return list1;
    }

    protected PublicationDto publicationToPublicationDto(Publication publication) {
        if ( publication == null ) {
            return null;
        }

        PublicationDto.PublicationDtoBuilder publicationDto = PublicationDto.builder();

        publicationDto.date( publication.getDate() );
        publicationDto.location( locationToLocationDto( publication.getLocation() ) );

        return publicationDto.build();
    }

    protected ManualReferenceDto manualReferenceToManualReferenceDto(ManualReference manualReference) {
        if ( manualReference == null ) {
            return null;
        }

        ManualReferenceDto.ManualReferenceDtoBuilder manualReferenceDto = ManualReferenceDto.builder();

        manualReferenceDto.title( manualReference.getTitle() );
        manualReferenceDto.url( manualReference.getUrl() );
        manualReferenceDto.journalOrConference( manualReference.getJournalOrConference() );
        manualReferenceDto.authors( authorListToAuthorDtoList( manualReference.getAuthors() ) );
        manualReferenceDto.volume( manualReference.getVolume() );
        manualReferenceDto.paragraph( manualReference.getParagraph() );
        manualReferenceDto.pages( manualReference.getPages() );
        manualReferenceDto.publication( publicationToPublicationDto( manualReference.getPublication() ) );

        return manualReferenceDto.build();
    }

    protected List<ManualReferenceDto> manualReferenceListToManualReferenceDtoList(List<ManualReference> list) {
        if ( list == null ) {
            return null;
        }

        List<ManualReferenceDto> list1 = new ArrayList<ManualReferenceDto>( list.size() );
        for ( ManualReference manualReference : list ) {
            list1.add( manualReferenceToManualReferenceDto( manualReference ) );
        }

        return list1;
    }

    protected ReferencesDto referencesToReferencesDto(References references) {
        if ( references == null ) {
            return null;
        }

        ReferencesDto.ReferencesDtoBuilder referencesDto = ReferencesDto.builder();

        List<String> list = references.getDois();
        if ( list != null ) {
            referencesDto.dois( new ArrayList<String>( list ) );
        }
        referencesDto.manualReferences( manualReferenceListToManualReferenceDtoList( references.getManualReferences() ) );

        return referencesDto.build();
    }
}
