package com.finconsgroup.itserr.marketplace.search.dm.config;

import jakarta.annotation.PostConstruct;
import lombok.Builder;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * It contains the configuration for User Profile Search
 * @param search
 */
@ConfigurationProperties(prefix = "search-dm.profile")
@Builder
public record UserProfileSearchProperties(SearchProperties search) {

    @PostConstruct
    public void init() {
        // trigger initialization of calculated properties
        this.search.init();
    }
}
