package com.finconsgroup.itserr.marketplace.search.dm.config;

import jakarta.annotation.PostConstruct;
import lombok.Builder;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * It contains the configuration for News Search
 *
 * @param search the search configuration
 */
@ConfigurationProperties(prefix = "search-dm.news")
@Builder
public record NewsSearchProperties(SearchProperties search) {

    @PostConstruct
    public void init() {
        // trigger initialization of calculated properties
        this.search.init();
    }
}
