package com.finconsgroup.itserr.marketplace.search.dm.bean;

import com.finconsgroup.itserr.marketplace.core.web.bean.QueryFilter;
import lombok.Builder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * The request to filter by terms optionally using wildcard in the provided search fields
 * and additionally apply the filters.
 *
 * @param documentClass           the class representing the type of the documents to search for
 * @param sourceFields            the source fields to fetch
 * @param nestedPaths             the set of paths of nested type
 * @param ids                     the list of document ids to return
 * @param containsAnyTermsRequest the query request for contains any terms
 * @param queryFilters            the filters to be applied to fields
 * @param defaultPropertyTypeMap  the default property type map
 * @param includeScore            flag to indicate if score should be included in search result
 */
@Builder
public record ContainsAnyTermsWithFiltersRequest<T>(
    Class<T> documentClass,
    List<String> sourceFields,
    Set<String> nestedPaths,
    List<String> ids,
    ContainsAnyTermsRequest<T> containsAnyTermsRequest,
    List<QueryFilter> queryFilters,
    Map<String, String> defaultPropertyTypeMap,
    boolean includeScore) implements QueryRequest<T> {

    @Override
    public Class<T> getDocumentClass() {
        return documentClass;
    }

    @Override
    public List<String> getSourceFields() {
        return sourceFields;
    }

    @Override
    public boolean includeScore() {
        return includeScore;
    }
}
