package com.finconsgroup.itserr.marketplace.search.dm.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;

import java.util.List;


/**
 * Service for user favourite related operations.
 *
 * @param <F> the type of the search result
 */
public interface FavouriteService<F> {

    /**
     * Performs favourite search for the document index for {@code T} based on the ids and filters, and
     * returns the results as page of dto {@code F}
     *
     * @param ids    the ids of the items to return
     * @param filters  the filters to apply
     * @param pageable the page to return
     * @return the page of {@code F} of matching documents
     */
    @NonNull
    Page<F> getFavourite(@NonNull List<String> ids, String filters, @NonNull Pageable pageable);
}
