package com.finconsgroup.itserr.marketplace.search.dm.repository;

import com.finconsgroup.itserr.marketplace.search.dm.entity.Catalog;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.annotations.Query;
import org.springframework.data.elasticsearch.annotations.SourceFilters;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Spring Data Repository for {@link Catalog} to perform document
 * related operations
 */
@Repository
public interface CatalogRepository extends ElasticsearchRepository<Catalog, String>, CustomAggregationRepository, CustomQueryRepository {

    @Query("{\"bool\":{\"must\":[{\"query_string\":{\"analyze_wildcard\":true,\"fields\":[\"title\"],\"query\":\"?0\"}}]}}")
    SearchPage<Catalog> findByTitleContainsAny(String titleTerms, Pageable pageable);

    @Query("{\"bool\":{\"must\":[{\"query_string\":{\"analyze_wildcard\":true,\"fields\":[\"title\"],\"query\":\"?0\"}}]}}")
    @SourceFilters(includes = "?1")
    SearchPage<Catalog> findByTitleContainsAny(String titleTerms, List<String> sourceFilters, Pageable pageable);
}
