package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import org.springframework.lang.NonNull;

/**
 * Mapper that is aware of currently logged-in user, wrapping the actual mapper.
 * It is responsible for mapping any additional fields that depend on currently logged-in
 * user information.
 *
 * @param <T> the type of the document
 * @param <L> type of local search result
 */
public interface UserContextAwareMapper<T, L> {
    /**
     * Maps the entity to local search output dto,
     * applying any logged-in user dependent mapping logic.
     *
     * @param entity the type of the document
     * @return the mapped local search dto
     */
    @NonNull
    L toLocalSearchDto(@NonNull T entity);

}
