package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.constant.SecurityConstants;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputInstitutionalPageLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.InstitutionalPage;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * Mapper for all dto/entity conversions related to {@link InstitutionalPage}
 */
@Mapper(config = MapperConfiguration.class, uses = {UserProfileMapper.class})
public interface InstitutionalPageMapper {

    String NAMED_TO_ALLOWED_USER_IDS = "toAllowedUserIds";

    @Mapping(target = "score", ignore = true)
    @Mapping(target = "allowedUserIds", source = "dto", qualifiedByName = NAMED_TO_ALLOWED_USER_IDS)
    InstitutionalPage toEntity(InputInstitutionalPageDto dto);

    OutputInstitutionalPageDto toDto(InstitutionalPage entity);

    @Mapping(target = "title", source = "name")
    OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(InstitutionalPage entity);

    OutputInstitutionalPageLocalSearchDto toLocalSearchDto(InstitutionalPage entity);

    @Mapping(target = "title", source = "name")
    @Mapping(target = "description", source = "abstractContent")
    OutputGlobalSearchDataDto toGlobalSearchDataDto(InstitutionalPage entity);

    @Named(NAMED_TO_ALLOWED_USER_IDS)
    default Set<String> toAllowedUserIds(InputInstitutionalPageDto dto) {
        // allow all users to access public institutional pages
        if (Boolean.TRUE.equals(dto.getPublished())) {
            return Set.of(SecurityConstants.ALL_USERS);
        }

        Set<String> allowedUserIds = new LinkedHashSet<>();
        Optional.ofNullable(dto.getMembers()).orElse(List.of())
                .forEach(user -> allowedUserIds.add(user.getId()));
        Optional.ofNullable(dto.getWpLeads()).orElse(List.of())
                .forEach(user -> allowedUserIds.add(user.getId()));
        return allowedUserIds;
    }

}
