package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.InputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Event;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.springframework.lang.NonNull;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

/**
 * Mapper for all dto/entity conversions related to {@link Event}
 */
@Mapper(config = MapperConfiguration.class, uses = {UserProfileMapper.class})
public interface EventMapper {

    @Mapping(target = "score", ignore = true)
    Event toEntity(InputEventDto dto);

    OutputEventDto toDto(Event entity);

    OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(Event entity);

    @Mapping(target = "subscribed", ignore = true)
    OutputEventLocalSearchDto toLocalSearchDto(Event entity);

    @Mapping(target = "description", source = "content")
    @Mapping(target = "imageUrl", source = "image.url")
    OutputGlobalSearchDataDto toGlobalSearchDataDto(Event entity);

    /**
     * Indicates if the user is registered/subscribed for the event.
     *
     * @param entity the event entity
     * @param userId the user id to check
     * @return <code>true</code> if user is registered/subscribed, otherwise <code>false</code>
     */
    default boolean isSubscribed(@NonNull Event entity, UUID userId) {
        if (userId == null) {
            return false;
        }

        String userIdStr = userId.toString();
        return Optional.ofNullable(entity.getSubscribedParticipants()).orElse(List.of())
                .stream()
                .map(Event.SubscribedParticipant::getUserId)
                .anyMatch(userIdStr::equals);
    }
}
