package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.InputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Discussion;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * Mapper for all dto/entity conversions related to {@link Discussion}
 */
@Mapper(config = MapperConfiguration.class)
public interface DiscussionMapper {

    @Mapping(target = "score", ignore = true)
    Discussion toEntity(InputDiscussionDto dto);

    OutputDiscussionDto toDto(Discussion entity);

    OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(Discussion entity);

    OutputDiscussionLocalSearchDto toLocalSearchDto(Discussion entity);

    @Mapping(target = "description", source = "content")
    @Mapping(target = "imageUrl", source = "url")
    OutputGlobalSearchDataDto toGlobalSearchDataDto(Discussion entity);
}
