package com.finconsgroup.itserr.marketplace.search.dm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import com.finconsgroup.itserr.marketplace.search.dm.converter.InstantPropertyValueConverter;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.ValueConverter;
import org.springframework.data.elasticsearch.annotations.WriteTypeHint;

import java.time.Instant;
import java.util.List;

/**
 * It represents the persistent structure of News Search document for both Global and Local search.
 */
@SuppressWarnings("DefaultAnnotationParam")
@Document(
        indexName = "#{@environment.getProperty('search-dm.news.search.index-name','itserr-alias-wp2-search-news')}",
        createIndex = false,
        alwaysWriteMapping = false,
        writeTypeHint = WriteTypeHint.FALSE
)
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class News implements ScoredDocument {

    @Id
    private String id;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String title;

    @Field(type = FieldType.Object)
    private RegisteredAuthor creator;

    @Field(type = FieldType.Keyword)
    private String newsType;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String content;

    @Field(type = FieldType.Keyword)
    private List<String> tags;

    @Field(type = FieldType.Object)
    private List<InstitutionalPageMinimal> institutionalPages;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private ImageMinimal image;

    @Field(type = FieldType.Object)
    private List<RegisteredAuthor> authors;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant creationTime;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant updateTime;

    @Transient
    private Double score;

}
