package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload for project field to create/update/read a User Profile search document.
 */
@Builder
@Schema(
    title = "User Profile search document project DTO",
    description = "Represents the payload for project field of a User Profile search document"
)
@Data
public class UserProfileProjectDto {

    @Schema(
        description = "Project Id",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String projectId;

    @Schema(
        description = "Display Name",
        example = "WP3 - TRS")
    private String displayName;

    @Schema(
        description = "Work package code",
        example = "wp3")
    private String wp;

    @Schema(
            description = "Root Project Id",
            example = "123e4567-e89b-12d3-a456-426614174000")
    private String rootProjectId;

    @Schema(
            description = "Root Project Display Name",
            example = "WP3 - TRS")
    private String rootProjectDisplayName;

}
