package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.UUID;

/**
 * DTO for program subscribed participant.
 */
@Schema(name = "ProgramSubscribedParticipantDto", description = "DTO representing a program subscribed participant in responses")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class ProgramSubscribedParticipantDto {

    @Schema(description = "The ID of the subscribed participant", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID id;

    @Schema(description = "The ID of the program", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID programId;

    @Schema(description = "The ID of the subscribed participant user profile", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID userId;

    @Schema(description = "True, if the participant is attending remotely (online)", example = "false")
    private Boolean remoteParticipation;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;
}
