package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * It represents the response for a User Profile search document for local search.
 */
@Builder
@Schema(
    title = "User Profile search document response DTO for local search",
    description = "Represents the response for User Profile search document for local search"
)
@Data
public class OutputUserProfileLocalSearchDto {
    @Schema(
        description = "ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
        description = "First Name",
        example = "John")
    private String firstName;

    @Schema(
        description = "Last Name",
        example = "Doe")
    private String lastName;

    @Schema(
            description = "Projects")
    private List<UserProfileProjectDto> projects;

    @Schema(
        description = "Short biography of the user",
        example = "Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;

    @Schema(
            description = "Whether the user is open to collaboration",
            example = "false")
    private Boolean openToCollaboration;

    @Schema(
        description = "Organization affiliation",
        example = "Stanford University")
    private String organizationAffiliation;

    @Schema(
        description = "Scientific Disciplinary Sectors",
        example = "[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;

    @Schema(
            description = "Areas of Expertise")
    private List<ExpertiseDto> expertises;

    @Schema(
        description = "Image URL",
        example = "http://localhost/test/image.png")
    private String imageUrl;

    @Schema(description = "User preferred language")
    private String language;

    @Schema(description = " thematic interests of user", example = "[\"Physics\", \"Maths\"]")
    private List<String> interests;
}
