package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.List;

/**
 * It represents the response for an News search document.
 */
@Builder
@Schema(name = "OutputNewsLocalSearchDto",
        title = "News search document response DTO",
        description = "Represents the response for News search document")
@Data
public class OutputNewsLocalSearchDto {

    @Schema(description = "Unique identifier of the news", example = "550e8400-e29b-41d4-a716-446655440000")
    private String id;

    @Schema(description = "The title of the news", example = "Annual Tech Conference 2025")
    private String title;

    @Schema(description = "The creator of the News")
    private RegisteredAuthorDto creator;

    @Schema(description = "The type of news", example = "Technology")
    private String newsType;

    @Schema(description = "The content of the news", example = "Join us for the biggest tech conference of the year...")
    private String content;

    @Schema(description = "List of tags associated with the news", example = "[\"technology\", \"conference\", \"innovation\"]")
    private List<String> tags;

    @Schema(description = "List of institutional pages")
    private List<InstitutionalPageMinimalDto> institutionalPages;

    @Schema(description = "The image for the news")
    private ImageMinimalDto image;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;
}