package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;

/**
 * It represents the response for a Catalog search document for favourites.
 */
@SuperBuilder
@Schema(
    title = "Catalog search document response DTO for favourite",
    description = "Represents the response for Catalog search document for favourite"
)
@Data
public class OutputCatalogFavouriteDto {

    @Schema(
        description = "ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
        description = "Title",
        example = "Test Title")
    private String title;

    // TODO: Remove before commit - changed from list of OutputCatalogMinimalTagDto to list of string
    @Schema(
        description = "Catalog Tags")
    private List<String> tags;

    @Schema(
        description = "Authors")
    private List<AuthorDto> authors;

    @Schema(
        description = "Language",
        example = "EN")
    private String language;

    // TODO: Remove before commit - renamed from createTs type to createdAt
    @Schema(
        description = "Created Timestamp",
        example = "2025-03-31T09:29:20.428656Z")
    private Instant createdAt;

    @Schema(
        description = "Description",
        example = "Test abstract for the item")
    private String description;

    // TODO: Remove before commit - changed from string to CatalogTypeDto
    @Schema(
        description = "Catalog Item Type")
    private CatalogTypeDto type;

    // TODO: Remove before commit - removed version
    @Schema(
        description = "Image URL",
        example = "http://localhost/test/image.png")
    private String imageUrl;

    // TODO: Remove before commit - removed metrics
    @Schema(
        description = "Maintainer")
    private AuthorDto maintainer;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateTimeFormats.ISO_DATE)
    @Schema(
        description = "Date",
        example = "2025-03-31")
    private LocalDate publicationDate;

    @Schema(
        description = "DOI",
        example = "https://doi.org/10.1234%2Fabcdefg")
    private String doi;

}
