package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the persistent structure of repositories field of Institutional Page for both Global and Local search.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstitutionalPageRepositoriesDto {

    @Schema(description = "URL of the source repository", example = "https://github.com/example/wp3-tres")
    private String repoName;

    @Schema(description = "URL of the website", example = "https://www.wp3tres.com")
    private String website;
}
