package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the persistent structure of parent field of Institutional Page for both Global and Local search.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstitutionalPageParentDto {

    @Schema(
        description = "Institutional Page Id",
        example = "0ce88ee0-3724-4e57-953f-887e4a7fc679")
    private String institutionalPageId;

    @Schema(
        description = "Institutional Page Name",
        example = "Root Page")
    private String institutionalPageName;

    @Schema(
        description = "Workspace Folder Id",
        example = "0dc223d9-70f5-4a6e-b9e4-e53658ce0516")
    private String workspaceFolderId;

    @Schema(
        description = "Workspace Folder Name",
        example = "Root Folder")
    private String workspaceFolderName;

    @Schema(description = "Category", example = "tool")
    private String category;
}
