package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the persistent structure of button field of Institutional Page for both Global and Local search.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstitutionalPageButtonDto {

    @Schema(description = "The label of the button", example = "Download Criterion")
    private String label;

    @Schema(description = "The action link of the button", example = "https://www.google.com/")
    private String link;

    @Schema(description = "The type of the button, used to determine its behavior.", example = "Download")
    private String buttonType;

    @Schema(description = "CSS class name for the icon displayed inside the button", example = "fa-download")
    private String iconCssClass;
}
