package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.core.web.dto.PutIdParameterBody;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.Map;


/**
 * It represents the payload to create/update Discussion search document.
 */
@Builder
@Schema(name = "InputDiscussionDto",
        title = "Create/Update Discussion search document DTO",
        description = "Represents the payload to create/update Discussion search document")
@Data
public class InputDiscussionDto implements PutIdParameterBody {

    @Schema(description = "Unique identifier of the event", example = "550e8400-e29b-41d4-a716-446655440000")
    @NotBlank
    private String id;

    @Schema(description = "The title of the discussion", example = "Annual Tech Conference 2025")
    private String title;

    @Schema(description = "The content of the discussion",
            example = "Join us for the biggest tech conference of the year...")
    private String content;

    @Schema(description = "The identifier of the user who created the discussion",
            example = "550e8400-e29b-41d4-a716-446655440000")
    private String createdBy;

    @Schema(description = "The date and time when the discussion was created", example = "2025-06-20T15:29:06.254836Z")
    private Instant createdAt;

    @Schema(description = "The identifier of the user who updated the discussion",
            example = "550e8400-e29b-41d4-a716-446655440000")
    private String updatedBy;

    @Schema(description = "The date and time when the discussion was last updated",
            example = "2025-06-20T15:29:06.254836Z")
    private Instant updatedAt;

    @Schema(description = "The identifier of an external resource associated with the discussion",
            example = "550e8400-e29b-41d4-a716-446655440000")
    private String resourceId;

    @Schema(description = "The type of the external resource associated with the discussion",
            example = "news")
    private String resourceType;

    @Schema(description = "The visibility setting of the discussion.",
            example = "public")
    private String visibility;

    @Schema(description = "The URL associated with the discussion",example = "https://meeting.example.com/post123")
    private String url;

    @Schema(description = "The user information of the user who created the discussion.")
    private DiscussionUserInfoDto userInfoDTO;

    @Schema(description = "The count by reactions added by other users.",
            example = "{\"like\": 5, \"celebrate\": 3, \"love\": 2 }")
    private Map<String, Long> reactionCounts;

    @Schema(description = "The count by reactions added by other users.", example = "0")
    private Long threadsCount;

    @Schema(hidden = true)
    @JsonIgnore
    @Hidden
    @Override
    public String getPutId() {
        return id;
    }
}
