package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload for metrics field to create/update a Catalog search document.
 */
@Builder
@Schema(
    title = "Create/Update Catalog search document metrics DTO",
    description = "Represents the payload for metrics field to create/update a Catalog search document"
)
@Data
public class InputCatalogMetricsDto {

    @Schema(
        description = "Downloads",
        example = "1")
    private Long downloads;

    @Schema(
        description = "Reads",
        example = "1")
    private Long reads;

    @Schema(
        description = "Favorites",
        example = "1")
    private Long favorites;
}
