package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * DTO for expertise details.
 */
@Schema(name = "ExpertiseDto", description = "Data Transfer Object representing a user's expertise")
@Data
@Builder
@AllArgsConstructor
public class ExpertiseDto {

    @Schema(description = "Unique identifier of the expertise", example = "550e8400-e29b-41d4-a716-446655440000")
    private String id;

    @Schema(description = "Unique identifier of the label", example = "550e8400-e29b-41d4-a716-446655440000")
    private String labelId;

    @Schema(description = "Display name of the expertise (e.g., skill name)", example = "Java Development")
    private String displayName;

    @Schema(description = "Number of endorsements received for this expertise", example = "42")
    private Integer endorsementCount;

    @Schema(description = "Areas of Expertise")
    private List<EndorsementDto> endorsements;
}

