package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * DTO for a discussion user information.
 */
@Schema(name = "DiscussionUserInfoDto", description = "DTO representing a discussion user information")
@Data
@Builder
@AllArgsConstructor
public class DiscussionUserInfoDto {
    @Schema(
            description = "Id",
            example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
            description = "First Name",
            example = "John")
    private String firstName;

    @Schema(
            description = "Last Name",
            example = "Doe")
    private String lastName;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @Schema(
            description = "Email",
            example = "john.doe@example.com",
            accessMode = Schema.AccessMode.WRITE_ONLY)
    private String email;

    @Schema(
            description = "preferred Username of the user",
            example = "john.doe.213213")
    private String preferredUsername;

    @Schema(
            description = "Link of the image of user",
            example = "https://imageLink")
    private String imageUrl;

    @Schema(description = "Short biography of the user", example = "Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;

    @Schema(
            description = "orcid",
            example = "00000-00000-00000-00000")
    private String orcid;
}
