package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;

/**
 * It represents the resource field for catalog item.
 */
@Builder
@Schema(
    name = "CatalogResourceDto",
    description = "Represents the resource field for catalog item"
)
@Data
public class CatalogResourceDto {

    @Schema(description = "Resource name/identifier (unique per item)", example = "dataset-file")
    private String name;

    @Schema(description = "Description of the resource", example = "Primary dataset file")
    private String description;

    @Schema(description = "URL to the resource", example = "https://data.d4science.net/6Esi")
    private String url;

    @Schema(description = "Type of the resource", example = "dataset")
    private String type;

    @Schema(description = "Mime type", example = "plain/text")
    private String mimeType;

    @Schema(description = "User who created the resource", example = "3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private String createdBy;

    @Schema(description = "Creation timestamp", example = "2025-11-14T10:00:00Z")
    private Instant createdAt;

    @Schema(description = "User who last updated the resource", example = "3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private String updatedBy;

    @Schema(description = "Last update timestamp", example = "2025-11-14T10:00:00Z")
    private Instant updatedAt;

}
