package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * It represents the payload for references field of a catalog item search document.
 */
@Builder
@Schema(
    title = "DTO for References field of search document",
    description = "Represents the payload for references field to create/update a catalog item search document"
)
@Data
public class CatalogReferencesDto {

    @Schema(
        description = "DOIs",
        example = "[\"https://doi.org/10.1234%2Fabcdefg\"]")
    private List<String> dois;

    @Schema(
        description = "Manual References")
    private List<CatalogManualReferenceDto> manualReferences;
}
