package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * It represents the payload for manual reference field of a catalog item search document.
 */
@Builder
@Schema(
    title = "DTO for Manual Reference field of search document",
    description = "Represents the payload for manual reference field to create/update a catalog item search document"
)
@Data
public class CatalogManualReferenceDto {

    @Schema(
        description = "Title",
        example = "Test Ref Title")
    private String title;

    @Schema(
        description = "URL",
        example = "http://localhost/catalog/test")
    private String url;

    @Schema(
        description = "Authors")
    private List<AuthorDto> authors;

    @Schema(
        description = "Volume",
        example = "1")
    private String volume;

    @Schema(
        description = "Paragraph",
        example = "10")
    private String paragraph;

    @Schema(
        description = "Pages",
        example = "xxx")
    private String pages;

    @Schema(
        description = "Publication")
    private CatalogPublicationDto publication;
}
