package com.finconsgroup.itserr.marketplace.search.dm.converter;

import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import org.springframework.data.elasticsearch.core.mapping.PropertyValueConverter;
import org.springframework.lang.NonNull;

/**
 * Converter class for converting between {@link Category} and {@link String} for any
 * search document.
 * As these are not auto registered, will need to use
 * {@link org.springframework.data.elasticsearch.annotations.ValueConverter} annotations to apply
 * it to the specific fields of the document.
 */
public class CategoryPropertyValueConverter implements PropertyValueConverter {

    @NonNull
    @Override
    public Object read(@NonNull Object value) {
        if (value instanceof String strValue) {
            return Category.ofId(strValue);
        }
        return Category.ofId(value.toString());
    }

    @NonNull
    @Override
    public Object write(@NonNull Object value) {
        if (value instanceof Category category) {
            return category.getId();
        }

        return value.toString();
    }

}
