package com.finconsgroup.itserr.marketplace.search.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.utils.OpenApiUtils;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.List;

@Tag(name = "GlobalSearch", description = "Operations related to global search")
@SecurityRequirement(name = "BearerAuth")
@ApiResponses(value = {
    @ApiResponse(responseCode = "500", ref = OpenApiUtils.RESPONSE_INTERNAL_SERVER_ERROR)
})
public interface GlobalSearchApi {

    /**
     * Retrieves a limited list of global search autocompletion results matching the provided terms for all entity types.
     *
     * @param terms the terms to search for
     * @return the list of {@link OutputGlobalSearchAutoCompleteDto} and HTTP status 200 (OK)
     */
    @Operation(
        summary = "Perform global search for autocompletion and retrieve the results",
        description = "Perform the global for autocompletion search based on the terms provided and retrieve results"
    )
    @ApiResponses(value = {
        @ApiResponse(responseCode = "200", description = "OK"),
        @ApiResponse(responseCode = "400", ref = OpenApiUtils.RESPONSE_BAD_REQUEST)
    })
    @ResponseStatus(HttpStatus.OK)
    @GetMapping(value = "/global/auto-complete", produces = MediaType.APPLICATION_JSON_VALUE)
    List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(
        @NotNull @Size(min = 3) @RequestParam("terms") String terms
    );

    /**
     * Retrieves a limited list of global search results matching the provided terms for all entity types.
     *
     * @param terms the terms to search for
     * @return the list of {@link OutputGlobalSearchDto} and HTTP status 200 (OK)
     */
    @Operation(
        summary = "Perform global search retrieve the results",
        description = "Perform the global search based on the terms provided and retrieve results"
    )
    @ApiResponses(value = {
        @ApiResponse(responseCode = "200", description = "OK"),
        @ApiResponse(responseCode = "400", ref = OpenApiUtils.RESPONSE_BAD_REQUEST)
    })
    @ResponseStatus(HttpStatus.OK)
    @GetMapping(value = "/global/search", produces = MediaType.APPLICATION_JSON_VALUE)
    List<OutputGlobalSearchDto> getSearch(
        @NotNull @Size(min = 3) @RequestParam("terms") String terms
    );

}
