/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.core.web.dto.PutIdParameterBody;
import com.finconsgroup.itserr.marketplace.search.dm.dto.DiscussionUserInfoDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputDiscussionDto;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;

@Schema(name="InputDiscussionDto", title="Create/Update Discussion search document DTO", description="Represents the payload to create/update Discussion search document")
public class InputDiscussionDto
implements PutIdParameterBody {
    @Schema(description="Unique identifier of the event", example="550e8400-e29b-41d4-a716-446655440000")
    @NotBlank
    private String id;
    @Schema(description="The title of the discussion", example="Annual Tech Conference 2025")
    private String title;
    @Schema(description="The content of the discussion", example="Join us for the biggest tech conference of the year...")
    private String content;
    @Schema(description="The identifier of the user who created the discussion", example="550e8400-e29b-41d4-a716-446655440000")
    private String createdBy;
    @Schema(description="The date and time when the discussion was created", example="2025-06-20T15:29:06.254836Z")
    private Instant createdAt;
    @Schema(description="The identifier of the user who updated the discussion", example="550e8400-e29b-41d4-a716-446655440000")
    private String updatedBy;
    @Schema(description="The date and time when the discussion was last updated", example="2025-06-20T15:29:06.254836Z")
    private Instant updatedAt;
    @Schema(description="The identifier of an external resource associated with the discussion", example="550e8400-e29b-41d4-a716-446655440000")
    private String resourceId;
    @Schema(description="The type of the external resource associated with the discussion", example="news")
    private String resourceType;
    @Schema(description="The visibility setting of the discussion.", example="public")
    private String visibility;
    @Schema(description="The URL associated with the discussion", example="https://meeting.example.com/post123")
    private String url;
    @Schema(description="The user information of the user who created the discussion.")
    private DiscussionUserInfoDto userInfoDTO;
    @Schema(description="The count by reactions added by other users.", example="{\"like\": 5, \"celebrate\": 3, \"love\": 2 }")
    private Map<String, Long> reactionCounts;
    @Schema(description="The count by reactions added by other users.", example="0")
    private Long threadsCount;

    @Schema(hidden=true)
    @JsonIgnore
    @Hidden
    public String getPutId() {
        return this.id;
    }

    @Generated
    InputDiscussionDto(String id, String title, String content, String createdBy, Instant createdAt, String updatedBy, Instant updatedAt, String resourceId, String resourceType, String visibility, String url, DiscussionUserInfoDto userInfoDTO, Map<String, Long> reactionCounts, Long threadsCount) {
        this.id = id;
        this.title = title;
        this.content = content;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.updatedBy = updatedBy;
        this.updatedAt = updatedAt;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.visibility = visibility;
        this.url = url;
        this.userInfoDTO = userInfoDTO;
        this.reactionCounts = reactionCounts;
        this.threadsCount = threadsCount;
    }

    @Generated
    public static InputDiscussionDtoBuilder builder() {
        return new InputDiscussionDtoBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public String getResourceType() {
        return this.resourceType;
    }

    @Generated
    public String getVisibility() {
        return this.visibility;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public DiscussionUserInfoDto getUserInfoDTO() {
        return this.userInfoDTO;
    }

    @Generated
    public Map<String, Long> getReactionCounts() {
        return this.reactionCounts;
    }

    @Generated
    public Long getThreadsCount() {
        return this.threadsCount;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Generated
    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Generated
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @Generated
    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUserInfoDTO(DiscussionUserInfoDto userInfoDTO) {
        this.userInfoDTO = userInfoDTO;
    }

    @Generated
    public void setReactionCounts(Map<String, Long> reactionCounts) {
        this.reactionCounts = reactionCounts;
    }

    @Generated
    public void setThreadsCount(Long threadsCount) {
        this.threadsCount = threadsCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputDiscussionDto)) {
            return false;
        }
        InputDiscussionDto other = (InputDiscussionDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$threadsCount = this.getThreadsCount();
        Long other$threadsCount = other.getThreadsCount();
        if (this$threadsCount == null ? other$threadsCount != null : !((Object)this$threadsCount).equals(other$threadsCount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$visibility = this.getVisibility();
        String other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        DiscussionUserInfoDto this$userInfoDTO = this.getUserInfoDTO();
        DiscussionUserInfoDto other$userInfoDTO = other.getUserInfoDTO();
        if (this$userInfoDTO == null ? other$userInfoDTO != null : !this$userInfoDTO.equals(other$userInfoDTO)) {
            return false;
        }
        Map this$reactionCounts = this.getReactionCounts();
        Map other$reactionCounts = other.getReactionCounts();
        return !(this$reactionCounts == null ? other$reactionCounts != null : !((Object)this$reactionCounts).equals(other$reactionCounts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputDiscussionDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $threadsCount = this.getThreadsCount();
        result = result * 59 + ($threadsCount == null ? 43 : ((Object)$threadsCount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        DiscussionUserInfoDto $userInfoDTO = this.getUserInfoDTO();
        result = result * 59 + ($userInfoDTO == null ? 43 : $userInfoDTO.hashCode());
        Map $reactionCounts = this.getReactionCounts();
        result = result * 59 + ($reactionCounts == null ? 43 : ((Object)$reactionCounts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputDiscussionDto(id=" + this.getId() + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", createdBy=" + this.getCreatedBy() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedBy=" + this.getUpdatedBy() + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", resourceId=" + this.getResourceId() + ", resourceType=" + this.getResourceType() + ", visibility=" + this.getVisibility() + ", url=" + this.getUrl() + ", userInfoDTO=" + String.valueOf(this.getUserInfoDTO()) + ", reactionCounts=" + String.valueOf(this.getReactionCounts()) + ", threadsCount=" + this.getThreadsCount() + ")";
    }
}

