package com.finconsgroup.itserr.marketplace.search.dm.repository.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.search.dm.bean.QueryRequest;
import com.finconsgroup.itserr.marketplace.search.dm.opensearch.OpenSearchHelper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.data.core.OpenSearchOperations;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;

@Component
@RequiredArgsConstructor
@Slf4j
public class CustomQueryRepositoryOpenSearchImpl implements CustomQueryRepository {

    private final OpenSearchClient openSearchClient;
    private final OpenSearchHelper openSearchHelper;
    private final OpenSearchOperations openSearchOperations;

    @Override
    public <T> List<T> findTopHitsForQuery(QueryRequest<T> queryRequest, int topHitsLimit) {
        String[] indexNames = openSearchOperations.getIndexCoordinatesFor(queryRequest.getDocumentClass()).getIndexNames();
        SearchRequest searchRequest = openSearchHelper.buildTopHitsSearchRequest(queryRequest, topHitsLimit, indexNames);
        try {
            SearchResponse<T> searchResponse = openSearchClient.search(searchRequest, queryRequest.getDocumentClass());
            return openSearchHelper.mapTopHitsSearchResponse(searchResponse, queryRequest);
        } catch (IOException e) {
            throw new WP2ExecutionException(e);
        }
    }

    @Override
    public <T> Page<T> findPageForQuery(QueryRequest<T> queryRequest, Pageable pageable) {
        String[] indexNames = openSearchOperations.getIndexCoordinatesFor(queryRequest.getDocumentClass()).getIndexNames();
        SearchRequest searchRequest = openSearchHelper.buildFindPageSearchRequest(queryRequest, pageable, indexNames);
        try {
            SearchResponse<T> searchResponse = openSearchClient.search(searchRequest, queryRequest.getDocumentClass());
            return openSearchHelper.mapPageSearchResponse(searchResponse, queryRequest, pageable);
        } catch (IOException e) {
            throw new WP2ExecutionException(e);
        }
    }
}
