package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.DiscussionUserInfoDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Discussion;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-09T11:44:03+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class DiscussionMapperImpl implements DiscussionMapper {

    @Override
    public Discussion toEntity(InputDiscussionDto dto) {
        if ( dto == null ) {
            return null;
        }

        Discussion.DiscussionBuilder discussion = Discussion.builder();

        discussion.id( dto.getId() );
        discussion.title( dto.getTitle() );
        discussion.content( dto.getContent() );
        discussion.createdBy( dto.getCreatedBy() );
        discussion.createdAt( dto.getCreatedAt() );
        discussion.updatedBy( dto.getUpdatedBy() );
        discussion.updatedAt( dto.getUpdatedAt() );
        discussion.resourceId( dto.getResourceId() );
        discussion.resourceType( dto.getResourceType() );
        discussion.visibility( dto.getVisibility() );
        discussion.url( dto.getUrl() );
        discussion.userInfoDTO( discussionUserInfoDtoToUserInfo( dto.getUserInfoDTO() ) );
        Map<String, Long> map = dto.getReactionCounts();
        if ( map != null ) {
            discussion.reactionCounts( new LinkedHashMap<String, Long>( map ) );
        }
        discussion.threadsCount( dto.getThreadsCount() );

        return discussion.build();
    }

    @Override
    public OutputDiscussionDto toDto(Discussion entity) {
        if ( entity == null ) {
            return null;
        }

        OutputDiscussionDto.OutputDiscussionDtoBuilder outputDiscussionDto = OutputDiscussionDto.builder();

        outputDiscussionDto.id( entity.getId() );
        outputDiscussionDto.title( entity.getTitle() );
        outputDiscussionDto.content( entity.getContent() );
        outputDiscussionDto.createdBy( entity.getCreatedBy() );
        outputDiscussionDto.createdAt( entity.getCreatedAt() );
        outputDiscussionDto.updatedBy( entity.getUpdatedBy() );
        outputDiscussionDto.updatedAt( entity.getUpdatedAt() );
        outputDiscussionDto.resourceId( entity.getResourceId() );
        outputDiscussionDto.resourceType( entity.getResourceType() );
        outputDiscussionDto.visibility( entity.getVisibility() );
        outputDiscussionDto.url( entity.getUrl() );
        outputDiscussionDto.userInfoDTO( userInfoToDiscussionUserInfoDto( entity.getUserInfoDTO() ) );
        Map<String, Long> map = entity.getReactionCounts();
        if ( map != null ) {
            outputDiscussionDto.reactionCounts( new LinkedHashMap<String, Long>( map ) );
        }
        outputDiscussionDto.threadsCount( entity.getThreadsCount() );

        return outputDiscussionDto.build();
    }

    @Override
    public OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(Discussion entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchAutoCompleteDataDto.OutputGlobalSearchAutoCompleteDataDtoBuilder outputGlobalSearchAutoCompleteDataDto = OutputGlobalSearchAutoCompleteDataDto.builder();

        outputGlobalSearchAutoCompleteDataDto.id( entity.getId() );
        outputGlobalSearchAutoCompleteDataDto.title( entity.getTitle() );
        outputGlobalSearchAutoCompleteDataDto.score( entity.getScore() );

        return outputGlobalSearchAutoCompleteDataDto.build();
    }

    @Override
    public OutputDiscussionLocalSearchDto toLocalSearchDto(Discussion entity) {
        if ( entity == null ) {
            return null;
        }

        OutputDiscussionLocalSearchDto.OutputDiscussionLocalSearchDtoBuilder outputDiscussionLocalSearchDto = OutputDiscussionLocalSearchDto.builder();

        outputDiscussionLocalSearchDto.id( entity.getId() );
        outputDiscussionLocalSearchDto.title( entity.getTitle() );
        outputDiscussionLocalSearchDto.content( entity.getContent() );
        outputDiscussionLocalSearchDto.createdBy( entity.getCreatedBy() );
        outputDiscussionLocalSearchDto.createdAt( entity.getCreatedAt() );
        outputDiscussionLocalSearchDto.updatedBy( entity.getUpdatedBy() );
        outputDiscussionLocalSearchDto.updatedAt( entity.getUpdatedAt() );
        outputDiscussionLocalSearchDto.resourceId( entity.getResourceId() );
        outputDiscussionLocalSearchDto.resourceType( entity.getResourceType() );
        outputDiscussionLocalSearchDto.visibility( entity.getVisibility() );
        outputDiscussionLocalSearchDto.url( entity.getUrl() );
        outputDiscussionLocalSearchDto.userInfoDTO( userInfoToDiscussionUserInfoDto( entity.getUserInfoDTO() ) );
        Map<String, Long> map = entity.getReactionCounts();
        if ( map != null ) {
            outputDiscussionLocalSearchDto.reactionCounts( new LinkedHashMap<String, Long>( map ) );
        }
        outputDiscussionLocalSearchDto.threadsCount( entity.getThreadsCount() );

        return outputDiscussionLocalSearchDto.build();
    }

    @Override
    public OutputGlobalSearchDataDto toGlobalSearchDataDto(Discussion entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchDataDto.OutputGlobalSearchDataDtoBuilder outputGlobalSearchDataDto = OutputGlobalSearchDataDto.builder();

        outputGlobalSearchDataDto.description( entity.getContent() );
        outputGlobalSearchDataDto.imageUrl( entity.getUrl() );
        outputGlobalSearchDataDto.id( entity.getId() );
        outputGlobalSearchDataDto.title( entity.getTitle() );
        outputGlobalSearchDataDto.score( entity.getScore() );

        return outputGlobalSearchDataDto.build();
    }

    protected Discussion.UserInfo discussionUserInfoDtoToUserInfo(DiscussionUserInfoDto discussionUserInfoDto) {
        if ( discussionUserInfoDto == null ) {
            return null;
        }

        Discussion.UserInfo.UserInfoBuilder userInfo = Discussion.UserInfo.builder();

        userInfo.id( discussionUserInfoDto.getId() );
        userInfo.firstName( discussionUserInfoDto.getFirstName() );
        userInfo.lastName( discussionUserInfoDto.getLastName() );
        userInfo.email( discussionUserInfoDto.getEmail() );
        userInfo.preferredUsername( discussionUserInfoDto.getPreferredUsername() );
        userInfo.imageUrl( discussionUserInfoDto.getImageUrl() );
        userInfo.shortBio( discussionUserInfoDto.getShortBio() );
        userInfo.orcid( discussionUserInfoDto.getOrcid() );

        return userInfo.build();
    }

    protected DiscussionUserInfoDto userInfoToDiscussionUserInfoDto(Discussion.UserInfo userInfo) {
        if ( userInfo == null ) {
            return null;
        }

        DiscussionUserInfoDto.DiscussionUserInfoDtoBuilder discussionUserInfoDto = DiscussionUserInfoDto.builder();

        discussionUserInfoDto.id( userInfo.getId() );
        discussionUserInfoDto.firstName( userInfo.getFirstName() );
        discussionUserInfoDto.lastName( userInfo.getLastName() );
        discussionUserInfoDto.email( userInfo.getEmail() );
        discussionUserInfoDto.preferredUsername( userInfo.getPreferredUsername() );
        discussionUserInfoDto.imageUrl( userInfo.getImageUrl() );
        discussionUserInfoDto.shortBio( userInfo.getShortBio() );
        discussionUserInfoDto.orcid( userInfo.getOrcid() );

        return discussionUserInfoDto.build();
    }
}
