package com.finconsgroup.itserr.marketplace.search.dm.repository;

import com.finconsgroup.itserr.marketplace.search.dm.bean.QueryRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.TopHitsAggregationRequest;

import java.util.List;
import java.util.Map;

/**
 * Interface to declare methods that use aggregations for queries and are not supported by the
 * Spring Data Repository.
 */
public interface CustomAggregationRepository {
    /**
     * It filters the documents based on the query and returns the limited number of top hits
     * grouped by the term.
     *
     * @param queryRequest       the query to filter documents
     * @param aggregationRequest the aggregation request for term and top hits
     * @param <T>                the type of document
     * @return the map of list of top hits grouped by the term
     * @throws com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException in case of any IO errors
     */
    <T> Map<String, List<T>> findTopHitsForQueryByTerm(
            QueryRequest<T> queryRequest, TopHitsAggregationRequest<T> aggregationRequest);
}
