package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

/**
 * It represents the result for data representing individual document of Global Search
 */
@RequiredArgsConstructor
@Getter
@Builder
@Schema(
    title = "Global Search Result Data DTO",
    description = "Represents the response for Global Search document"
)
@EqualsAndHashCode
@ToString
public class OutputGlobalSearchDataDto {
    @Schema(
        description = "Document Id",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private final String id;
    @Schema(
        description = "Title",
        example = "Workspace - ITSERR Shared")
    private final String title;
    @Schema(
        description = "Description",
        example = "This handbook describes the 12 thematic IT services.")
    private final String description;
    @Schema(
        description = "Image URL",
        example = "http://localhost/test/image.png")
    private final String imageUrl;
    @Schema(
        description = "The score from the search result",
        example = "1.0",
        hidden = true)
    private final Double score;
}
