/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.search.dm.api.DiagnosticsApi;
import com.finconsgroup.itserr.marketplace.search.dm.controller.DiagnosticsController;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputIngestDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import com.finconsgroup.itserr.marketplace.search.dm.service.CatalogService;
import com.finconsgroup.itserr.marketplace.search.dm.service.DiscussionService;
import com.finconsgroup.itserr.marketplace.search.dm.service.EventService;
import com.finconsgroup.itserr.marketplace.search.dm.service.InstitutionalPageService;
import com.finconsgroup.itserr.marketplace.search.dm.service.NewsService;
import com.finconsgroup.itserr.marketplace.search.dm.service.UserProfileService;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DiagnosticsController
implements DiagnosticsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsController.class);
    private final CatalogService catalogService;
    private final UserProfileService userProfileService;
    private final InstitutionalPageService institutionalPageService;
    private final EventService eventService;
    private final NewsService newsService;
    private final DiscussionService discussionService;
    private final ObjectMapper objectMapper;
    @Value(value="${log.log4j2-rolling-file-name}")
    private String log4j2RollingFileName;
    @Value(value="${search.dm.diagnostics.ingest-data-enabled}")
    private boolean ingestDataEnabled;

    public ResponseEntity<Resource> downloadLogs() {
        log.debug("call to DiagnosticsController - downloadLogs");
        Path filePath = Paths.get(this.getLogFilePathFromLog4j2(), new String[0]);
        log.debug("Trying to retrieve log file from: {}", (Object)filePath);
        File logFile = filePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            throw new WP2ResourceNotFoundException("Log file not found: %s".formatted(logFile.getAbsolutePath()));
        }
        FileSystemResource resource = new FileSystemResource(logFile);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DiagnosticsController.getContentDispositionHeaderValue((String)logFile.getName())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public ResponseEntity<OutputIngestDataDto> ingestData(Category category, String body) {
        if (!this.ingestDataEnabled) {
            throw new WP2AuthorizationException("Forbidden");
        }
        OutputIngestDataDto outputIngestData = switch (7.$SwitchMap$com$finconsgroup$itserr$marketplace$search$dm$enums$Category[category.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> this.ingestData(body, arg_0 -> ((CatalogService)this.catalogService).upsertDocument(arg_0), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            case 2 -> this.ingestData(body, arg_0 -> ((UserProfileService)this.userProfileService).upsertDocument(arg_0), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            case 3 -> this.ingestData(body, arg_0 -> ((InstitutionalPageService)this.institutionalPageService).upsertDocument(arg_0), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            case 4 -> this.ingestData(body, arg_0 -> ((EventService)this.eventService).upsertDocument(arg_0), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            case 5 -> this.ingestData(body, arg_0 -> ((NewsService)this.newsService).upsertDocument(arg_0), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            case 6 -> this.ingestData(body, arg_0 -> ((DiscussionService)this.discussionService).upsertDocument(arg_0), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        };
        return ResponseEntity.ok((Object)outputIngestData);
    }

    public String getLogFilePathFromLog4j2() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        RollingFileAppender appender = (RollingFileAppender)context.getConfiguration().getAppender(this.log4j2RollingFileName);
        return appender.getFileName();
    }

    private static String getContentDispositionHeaderValue(String fileName) {
        return "attachment; filename=\"%s\"".formatted(fileName);
    }

    private <T, R> OutputIngestDataDto ingestData(@NonNull String body, @NonNull Function<T, R> upsertFunction, @NonNull TypeReference<List<T>> typeReference) {
        try {
            List dtoList = (List)this.objectMapper.readValue(body, typeReference);
            int totalCount = 0;
            int failedCount = 0;
            int size = dtoList.size();
            LinkedList<String> errors = new LinkedList<String>();
            for (int i = 0; i < size; ++i) {
                try {
                    upsertFunction.apply(dtoList.get(i));
                }
                catch (Exception e) {
                    ++failedCount;
                    log.error("Failed to process record at index [{}] - {}", new Object[]{i, e.getMessage(), e});
                    errors.add(String.format("Failed to process record at index [%d] - %s", i, ExceptionUtils.getRootCause((Throwable)e)));
                }
                ++totalCount;
            }
            return OutputIngestDataDto.builder().totalCount(totalCount).failedCount(failedCount).successfulCount(totalCount - failedCount).errors(errors).build();
        }
        catch (JsonProcessingException e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    @Generated
    public DiagnosticsController(CatalogService catalogService, UserProfileService userProfileService, InstitutionalPageService institutionalPageService, EventService eventService, NewsService newsService, DiscussionService discussionService, ObjectMapper objectMapper) {
        this.catalogService = catalogService;
        this.userProfileService = userProfileService;
        this.institutionalPageService = institutionalPageService;
        this.eventService = eventService;
        this.newsService = newsService;
        this.discussionService = discussionService;
        this.objectMapper = objectMapper;
    }
}

