package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the response for metrics field for a Catalog search document.
 */
@Builder
@Schema(
    title = "Catalog search document metrics response DTO",
    description = "Represents the response for metrics field for Catalog search document"
)
@Data
public class OutputCatalogMetricsDto {

    @Schema(
        description = "Downloads",
        example = "1")
    private Long downloads;

    @Schema(
        description = "Reads",
        example = "1")
    private Long reads;

    @Schema(
        description = "Favorites",
        example = "1")
    private Long favorites;
}
