package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload for tags field to create/update a Catalog search document.
 */
@Builder
@Schema(
    title = "Create/Update Catalog search document tag DTO",
    description = "Represents the payload for tags field to create/update a Catalog search document"
)
@Data
public class InputCatalogTagDto {

    @Schema(
        description = "Vocabulary ID",
        example = "")
    private String vocabularyId;

    @Schema(
        description = "Status",
        example = "active")
    private String state;

    @Schema(
        description = "Display Name",
        example = "ITSERR")
    private String displayName;

    @Schema(
        description = "ID",
        example = "dc7e376a-059b-49be-90a0-e7fbdbcdc0ba")
    private String id;

    @Schema(
        description = "Name",
        example = "ITSERR")
    private String name;

}
