package com.finconsgroup.itserr.marketplace.search.dm.bean;


import java.util.List;

/**
 * Interface to identify the OpenSearch query request.
 *
 * @param <T> the type of the document returned by the query
 */
public interface QueryRequest<T> {
    /**
     * Return the class of the type to be queried
     *
     * @return the {@link Class} of the searched type
     */
    Class<T> getDocumentClass();

    /**
     * The list of source fields to return
     *
     * @return the {@link List} of source fields
     */
    List<String> getSourceFields();

    /**
     * The flag to indicate if wildcard search should be performed.
     *
     * @return {@code true} if wildcard search should be performed
     */
    default boolean useWildcard() {
        return false;
    }

    /**
     * The flag to indicate if search score should be returned.
     *
     * @return {@code true} if search score should be returned
     */
    default boolean includeScore() {
        return false;
    }
}
