package com.finconsgroup.itserr.marketplace.search.dm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import com.finconsgroup.itserr.marketplace.search.dm.converter.InstantPropertyValueConverter;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.ValueConverter;
import org.springframework.data.elasticsearch.annotations.WriteTypeHint;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;

/**
 * It represents the persistent structure of Catalog Search document for both Global and Local search.
 */
@SuppressWarnings("DefaultAnnotationParam")
@Document(
        indexName = "#{@environment.getProperty('search-dm.catalog.search.index-name','itserr-alias-wp2-search-catalog')}",
        createIndex = false,
        alwaysWriteMapping = false,
        writeTypeHint = WriteTypeHint.FALSE
)
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class Catalog implements ScoredDocument {

    @Id
    private String id;

    @Field(type = FieldType.Keyword)
    private String status;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String moderationMessage;

    @Field(type = FieldType.Keyword)
    private String createdBy;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant createdAt;

    @Field(type = FieldType.Keyword)
    private String updatedBy;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant updatedAt;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String title;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String description;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String imageUrl;

    @Field(type = FieldType.Object)
    private List<Paragraph> paragraphs;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String doi;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String license;

    @Field(type = FieldType.Object)
    private InstitutionalPage institutionalPag;

    @Field(type = FieldType.Object)
    private List<Author> authors;

    @Field(type = FieldType.Object)
    private Author maintainer;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private List<String> tags;

    @Field(type = FieldType.Keyword)
    private List<String> languages;

    @Field(type = FieldType.Object)
    private CatalogType type;

    @Field(type = FieldType.Object)
    private MetadataSet metadataSet;

    @Field(type = FieldType.Object)
    private References references;

    @Field(type = FieldType.Object)
    private List<Metadata> metadata;

    @Field(type = FieldType.Object)
    private Publication publication;

    @Field(type = FieldType.Object)
    private List<Resource> resources;

    @Transient
    private Double score;

    /**
     * It represents the persistent structure of paragraph field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Paragraph {

        @Field(type = FieldType.Keyword)
        private String id;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String title;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String content;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String imageUrl;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String resourceUrl;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private List<String> labels;

    }

    /**
     * It represents the persistent structure of institutional page field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class InstitutionalPage {

        @Field(type = FieldType.Keyword)
        private String id;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String name;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String abstractContent;

        @Field(type = FieldType.Keyword)
        private String category;
    }

    /**
     * It represents the persistent structure of catalog type field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class CatalogType {

        @Field(type = FieldType.Keyword)
        private String id;

        @Field(type = FieldType.Keyword)
        private String name;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String description;

        @Field(type = FieldType.Keyword)
        private String metadataId;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant createTs;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant updateTs;

        @Field(type = FieldType.Boolean)
        private Boolean deleteTs;

    }

    /**
     * It represents the persistent structure of metadata set field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class MetadataSet {

        @Field(type = FieldType.Keyword)
        private String id;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String name;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String description;

        @Field(type = FieldType.Boolean)
        private boolean standard;

    }

    /**
     * It represents the persistent structure of references field for search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class References {

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private List<String> dois;

        @Field(type = FieldType.Object)
        private List<ManualReference> manualReferences;
    }

    /**
     * It represents the persistent structure of manual reference field for search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ManualReference {

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String title;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String url;

        @Field(type = FieldType.Object)
        private List<Author> authors;

        @Field(type = FieldType.Keyword)
        private String volume;

        @Field(type = FieldType.Keyword)
        private String paragraph;

        @Field(type = FieldType.Keyword)
        private String pages;

        @Field(type = FieldType.Object)
        private Publication publication;
    }

    /**
     * It represents the persistent structure of publication field for search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Publication {

        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.ISO_DATE)
        private LocalDate date;

        @Field(type = FieldType.Keyword)
        private String zipCode;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String city;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String region;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String country;
    }

    /**
     * It represents the persistent structure of metadata field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Metadata {

        @Field(type = FieldType.Keyword)
        private String key;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String value;

    }

    /**
     * It represents the persistent structure of resource field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Resource {

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String name;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String description;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String url;

        @Field(type = FieldType.Keyword)
        private String type;

        @Field(type = FieldType.Keyword)
        private String mimeType;

        @Field(type = FieldType.Keyword)
        private String createdBy;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant createdAt;

        @Field(type = FieldType.Keyword)
        private String updatedBy;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant updatedAt;

    }
}
