package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.List;

/**
 * It represents the response for a Catalog search document for local search.
 */
@Builder
@Schema(
    title = "Catalog search document response DTO for local search",
    description = "Represents the response for Catalog search document for local search"
)
@Data
public class OutputCatalogLocalSearchDto {
    @Schema(
        description = "ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
        description = "Title",
        example = "Test Title")
    private String title;

    @Schema(
        description = "Catalog Tags")
    private List<String> tags;

    @Schema(
        description = "Authors")
    private List<AuthorDto> authors;

    @Schema(
        description = "Created Timestamp",
        example = "2025-03-31T09:29:20.428656Z")
    private Instant createdAt;

    @Schema(
        description = "Description",
        example = "Test abstract for the item")
    private String description;

    @Schema(
        description = "Catalog Item Type",
        example = "dataset")
    private CatalogTypeDto type;

    @Schema(
        description = "Image URL",
        example = "http://localhost/test/image.png")
    private String imageUrl;

    @Schema(
        description = "Maintainer")
    private AuthorDto maintainer;

}
