package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.core.web.dto.PutIdParameterBody;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.List;

/**
 * It represents the payload to create/update a Catalog search document.
 */
@Builder
@Schema(
    title = "Create/Update Catalog search document DTO",
    description = "Represents the payload to create/update a Catalog search document"
)
@Data
public class InputCatalogDto implements PutIdParameterBody {

    @Schema(
        description = "ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    @NotBlank
    private String id;

    @Schema(description = "Current status of the item", example = "DRAFT")
    private String status;

    @Schema(description = "Moderation message", example = "Item approved after review")
    private String moderationMessage;

    @Schema(description = "User who created the item", example = "3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private String createdBy;

    @Schema(description = "Creation timestamp", example = "2025-11-14T10:00:00Z")
    private Instant createdAt;

    @Schema(description = "User who last updated the item", example = "3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private String updatedBy;

    @Schema(description = "Last update timestamp", example = "2025-11-14T10:00:00Z")
    private Instant updatedAt;

    @Schema(description = "Title of the catalog item", example = "Sample Item")
    private String title;

    @Schema(description = "Abstract or summary of the catalog item", example = "Item description")
    private String description;

    @Schema(description = "The image url of the paragraph", example = "https://picsum.photos/200")
    private String imageUrl;

    @Schema(description = "The paragraphs related to the catalog item")
    private List<CatalogParagraphDto> paragraphs;

    @Schema(description = "Digital Object Identifier (DOI)", example = "https://doi.org/10.1234/xyz")
    private String doi;

    @Schema(description = "License type", example = "mit")
    private String license;

    @Schema(description = "Associated Institutional Page")
    private CatalogInstitutionalPageDto institutionalPag;

    @Schema(description = "List of authors for this catalog item")
    private List<AuthorDto> authors;

    @Schema(description = "Maintainer information")
    private AuthorDto maintainer;

    @Schema(description = "List of tags/labels")
    private List<String> tags;

    @Schema(description = "List of language codes", example = "[\"IT\", \"EN\"]")
    private List<String> languages;

    @Schema(description = "Associated Item Type")
    private CatalogTypeDto type;

    @Schema(description = "Metadata Set Information")
    private CatalogMetadataSetDto metadataSet;

    @Schema(description = "References (manual and DOI-based)")
    private CatalogReferencesDto references;

    @Schema(description = "List of custom metadata key-value pairs")
    private List<CatalogMetadataDto> metadata;

    @Schema(description = "Publication information")
    private CatalogPublicationDto publication;

    @Schema(description = "List of resources associated with this item")
    private List<CatalogResourceDto> resources;

    @JsonIgnore
    @Hidden
    @Override
    public String getPutId() {
        return id;
    }
}
