package com.finconsgroup.itserr.marketplace.search.dm.service;

import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * Service for global search related operations.
 */
public interface GlobalSearchService {

    /**
     * Search for documents for the provided title string which can contain multiple terms.
     * It returns the results in suitable format that can be used for autocompletion.
     *
     * @param terms the terms to search for
     * @return List of {@link OutputGlobalSearchAutoCompleteDto} of matching documents
     */
    @NonNull
    List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms);

    /**
     * Search for documents for the provided title string which can contain multiple terms.
     *
     * @param terms the terms to search for
     * @return List of {@link OutputGlobalSearchDto} of matching documents
     */
    @NonNull
    List<OutputGlobalSearchDto> getSearch(@NonNull String terms);
}
